/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.paths;

import io.apicurio.datamodels.TraverserDirection;
import io.apicurio.datamodels.VisitorUtil;
import io.apicurio.datamodels.models.MappedNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.union.Union;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathCreationVisitor;
import io.apicurio.datamodels.paths.NodePathSegment;
import io.apicurio.datamodels.util.NodeUtil;
import io.apicurio.datamodels.util.RegexUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NodePathUtil {
    public static NodePath createNodePath(Node node) {
        NodePathCreationVisitor visitor = new NodePathCreationVisitor();
        VisitorUtil.visitTree(node, visitor, TraverserDirection.up);
        return visitor.path;
    }

    public static NodePath parseNodePath(String path) {
        return NodePath.parse(path);
    }

    public static Node resolveNodePath(NodePath nodePath, Node from) {
        List<NodePathSegment> segments = nodePath.getSegments();
        Object current = from;
        for (NodePathSegment segment : segments) {
            if (!segment.isIndex()) {
                current = NodeUtil.getProperty(current, segment.getValue());
                continue;
            }
            if (NodeUtil.isUnion(current)) {
                Union union = (Union)current;
                current = union.unionValue();
            }
            if (NodeUtil.isNode(current)) {
                MappedNode mappedNode = (MappedNode)current;
                current = mappedNode.getItem(segment.getValue());
                continue;
            }
            if (NodeUtil.isList(current)) {
                int index = NodeUtil.toInteger(segment.getValue());
                List list = (List)current;
                current = list.get(index);
                continue;
            }
            if (!NodeUtil.isMap(current)) continue;
            Map map = (Map)current;
            current = NodeUtil.getMapItem(map, segment.getValue());
        }
        if (NodeUtil.isNode(current)) {
            return current;
        }
        return null;
    }

    public static List<String> detectPathParamNames(String path) {
        ArrayList<String> paramNames = new ArrayList<String>();
        List<String[]> matches = RegexUtil.findMatches(path, "\\{([^\\}]+)\\}");
        for (String[] match : matches) {
            String name = match[1];
            paramNames.add(name.trim());
        }
        return paramNames;
    }
}

