/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.other;

import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;

public class OasIgnoredHeaderParameterRule
extends ValidationRule {
    private static String[] ignoredHeaderNames = new String[]{"content-type", "accept", "authorization"};

    public OasIgnoredHeaderParameterRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitParameter(Parameter node) {
        OpenApiParameter param = (OpenApiParameter)node;
        if (this.hasValue(param.getName())) {
            boolean ignored = this.isValidEnumItem(param.getName().toLowerCase(), ignoredHeaderNames);
            this.reportIf(ignored, node, "name", this.map("name", param.getName()));
        }
    }
}

