/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.ModelTypeDetector;
import io.apicurio.datamodels.TraverserDirection;
import io.apicurio.datamodels.VisitorUtil;
import io.apicurio.datamodels.deref.Dereferencer;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.RootNode;
import io.apicurio.datamodels.models.asyncapi.AsyncApiDocument;
import io.apicurio.datamodels.models.io.ModelReader;
import io.apicurio.datamodels.models.io.ModelReaderFactory;
import io.apicurio.datamodels.models.io.ModelWriter;
import io.apicurio.datamodels.models.io.ModelWriterFactory;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Document;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Document;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.apicurio.datamodels.models.visitors.Visitor;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.refs.IReferenceResolver;
import io.apicurio.datamodels.refs.ReferenceResolverChain;
import io.apicurio.datamodels.transform.OpenApi20to30TransformationVisitor;
import io.apicurio.datamodels.transform.OpenApi30to31TransformationVisitor;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.util.ValidationUtil;
import io.apicurio.datamodels.validation.DefaultSeverityRegistry;
import io.apicurio.datamodels.validation.IValidationSeverityRegistry;
import io.apicurio.datamodels.validation.ValidationProblem;
import io.apicurio.datamodels.validation.ValidationVisitor;
import java.util.List;
import java.util.function.UnaryOperator;

public class Library {
    public static void addReferenceResolver(IReferenceResolver resolver) {
        ReferenceResolverChain.getInstance().addResolver(resolver);
    }

    public static void removeReferenceResolver(IReferenceResolver resolver) {
        ReferenceResolverChain.getInstance().removeResolver(resolver);
    }

    public static Document createDocument(ModelType type) {
        ModelReader reader = ModelReaderFactory.createModelReader(type);
        return (Document)((Object)reader.readRoot(JsonUtil.objectNode()));
    }

    public static Document readDocument(ObjectNode json) {
        ObjectNode clonedJson = (ObjectNode)JsonUtil.clone((JsonNode)json);
        ModelType type = ModelTypeDetector.discoverModelType(clonedJson);
        ModelReader reader = ModelReaderFactory.createModelReader(type);
        return (Document)((Object)reader.readRoot(clonedJson));
    }

    public static Document readDocumentFromJSONString(String jsonString) {
        ObjectNode json = (ObjectNode)JsonUtil.parseJSON(jsonString);
        return Library.readDocument(json);
    }

    public static ObjectNode writeDocument(Document document) {
        ModelWriter writer = ModelWriterFactory.createModelWriter(document.root().modelType());
        return writer.writeRoot((RootNode)((Object)document));
    }

    public static String writeDocumentToJSONString(Document document) {
        ObjectNode json = Library.writeDocument(document);
        return JsonUtil.stringify((JsonNode)json);
    }

    public static Node readNode(ObjectNode json, Node node) {
        ObjectNode clonedJson = (ObjectNode)JsonUtil.clone((JsonNode)json);
        Visitor readerDispatcher = ModelReaderFactory.createModelReaderDispatcher(node.root().modelType(), clonedJson);
        node.accept(readerDispatcher);
        return node;
    }

    public static ObjectNode writeNode(Node node) {
        ObjectNode json = JsonUtil.objectNode();
        Visitor writerDispatcher = ModelWriterFactory.createModelWriterDispatcher(node.root().modelType(), json);
        node.accept(writerDispatcher);
        return json;
    }

    public static String writeNodeToString(Node node) {
        ObjectNode json = Library.writeNode(node);
        return JsonUtil.stringify((JsonNode)json);
    }

    public static void visitNode(Node node, Visitor visitor) {
        node.accept(visitor);
    }

    public static void visitTree(Node node, Visitor visitor, TraverserDirection direction) {
        VisitorUtil.visitTree(node, visitor, direction);
    }

    public static NodePath createNodePath(Node node) {
        return NodePathUtil.createNodePath(node);
    }

    public static NodePath parseNodePath(String path) {
        return NodePathUtil.parseNodePath(path);
    }

    public static Node resolveNodePath(NodePath nodePath, Document doc) {
        return NodePathUtil.resolveNodePath(nodePath, doc);
    }

    public static Document transformDocument(Document source, ModelType toType) {
        if (source.root().modelType() == toType) {
            return source;
        }
        if (source.root().modelType() == ModelType.OPENAPI20 && toType == ModelType.OPENAPI30) {
            OpenApi20Document clone = (OpenApi20Document)Library.cloneDocument(source);
            OpenApi20to30TransformationVisitor transformer = new OpenApi20to30TransformationVisitor();
            VisitorUtil.visitTree(clone, transformer, TraverserDirection.down);
            return transformer.getResult();
        }
        if (source.root().modelType() == ModelType.OPENAPI30 && toType == ModelType.OPENAPI31) {
            OpenApi30to31TransformationVisitor transformer = new OpenApi30to31TransformationVisitor((OpenApi30Document)source);
            VisitorUtil.visitTree(source, transformer, TraverserDirection.down);
            return transformer.getResult();
        }
        if (source.root().modelType() == ModelType.OPENAPI20 && toType == ModelType.OPENAPI31) {
            Document doc30 = Library.transformDocument(source, ModelType.OPENAPI30);
            return Library.transformDocument(doc30, toType);
        }
        if (ModelTypeUtil.isAsyncApiModel(source)) {
            AsyncApiDocument doc = (AsyncApiDocument)source;
            String oldVersion = doc.getAsyncapi();
            String newVersion = ModelTypeUtil.getVersion(toType);
            doc.setAsyncapi(newVersion);
            AsyncApiDocument newDoc = (AsyncApiDocument)Library.cloneDocument(source);
            doc.setAsyncapi(oldVersion);
            return newDoc;
        }
        throw new RuntimeException("Transformation not supported.");
    }

    public static Document cloneDocument(Document source) {
        return Library.cloneDocument(source, UnaryOperator.identity());
    }

    public static Document cloneDocument(Document source, UnaryOperator<ObjectNode> transformer) {
        ObjectNode jsObj = (ObjectNode)transformer.apply(Library.writeNode(source));
        return Library.readDocument(jsObj);
    }

    public static List<ValidationProblem> validate(Node node, IValidationSeverityRegistry severityRegistry) {
        if (severityRegistry == null) {
            severityRegistry = new DefaultSeverityRegistry();
        }
        ValidationVisitor validator = ValidationUtil.createValidationVisitorForNode(node.root());
        validator.setSeverityRegistry(severityRegistry);
        Library.visitTree(node, validator, TraverserDirection.down);
        return validator.getValidationProblems();
    }

    public static Document dereferenceDocument(Document source) {
        return Library.dereferenceDocument(source, ReferenceResolverChain.getInstance(), false);
    }

    public static Document dereferenceDocument(Document source, boolean strict) {
        return Library.dereferenceDocument(source, ReferenceResolverChain.getInstance(), strict);
    }

    public static Document dereferenceDocument(Document source, IReferenceResolver resolver, boolean strict) {
        Dereferencer rl = new Dereferencer(resolver, strict);
        return rl.dereference(Library.cloneDocument(source));
    }
}

