/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;

public abstract class AbstractReplaceNodeCommand<T extends Node>
extends AbstractCommand {
    public NodePath _nodePath;
    public ObjectNode _new;
    public ObjectNode _old;

    public AbstractReplaceNodeCommand() {
    }

    public AbstractReplaceNodeCommand(T old, T replacement) {
        this._nodePath = Library.createNodePath(old);
        this._new = Library.writeNode(replacement);
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[ReplaceNodeCommand] Executing.", new Object[0]);
        this._old = null;
        Node oldNode = NodePathUtil.resolveNodePath(this._nodePath, document);
        if (this.isNullOrUndefined(oldNode)) {
            return;
        }
        this._old = Library.writeNode(oldNode);
        T newNode = this.readNode(oldNode.parent(), this._new);
        this.replaceNode(oldNode.parent(), newNode);
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[ReplaceNodeCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._old)) {
            return;
        }
        Node node = NodePathUtil.resolveNodePath(this._nodePath, document);
        if (this.isNullOrUndefined(node)) {
            return;
        }
        T restoreNode = this.readNode(node.parent(), this._old);
        this.replaceNode(node.parent(), restoreNode);
    }

    protected abstract void replaceNode(Node var1, T var2);

    protected abstract T readNode(Node var1, ObjectNode var2);
}

