/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Referenceable;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Schema;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Schema;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.util.NodeUtil;
import java.util.List;

public abstract class AbstractSchemaInhCommand
extends AbstractCommand {
    public static final String TYPE_NONE = "none";
    public static final String TYPE_ALL_OF = "allOf";
    public static final String TYPE_ONE_OF = "oneOf";
    public static final String TYPE_ANY_OF = "anyOf";

    static String getInheritanceType(Schema schema) {
        if (ModelTypeUtil.isOpenApiModel(schema)) {
            if (NodeUtil.isDefined(schema.getAllOf())) {
                return TYPE_ALL_OF;
            }
            if (ModelTypeUtil.isOpenApi3Model(schema)) {
                if (NodeUtil.isDefined(NodeUtil.getNodeProperty(schema, TYPE_ANY_OF))) {
                    return TYPE_ANY_OF;
                }
                if (NodeUtil.isDefined(NodeUtil.getNodeProperty(schema, TYPE_ONE_OF))) {
                    return TYPE_ONE_OF;
                }
            }
        } else if (ModelTypeUtil.isAsyncApiModel(schema)) {
            if (NodeUtil.isDefined(((AsyncApiSchema)schema).getAllOf())) {
                return TYPE_ALL_OF;
            }
            if (NodeUtil.isDefined(((AsyncApiSchema)schema).getAnyOf())) {
                return TYPE_ANY_OF;
            }
            if (NodeUtil.isDefined(((AsyncApiSchema)schema).getOneOf())) {
                return TYPE_ONE_OF;
            }
        }
        return TYPE_NONE;
    }

    protected Schema createSchema(Schema parentSchema, String inheritanceType) {
        if (NodeUtil.equals(TYPE_ALL_OF, inheritanceType)) {
            return AbstractSchemaInhCommand.createAllOfSchema(parentSchema);
        }
        if (NodeUtil.equals(TYPE_ANY_OF, inheritanceType)) {
            return AbstractSchemaInhCommand.createAnyOfSchema(parentSchema);
        }
        if (NodeUtil.equals(TYPE_ONE_OF, inheritanceType)) {
            return AbstractSchemaInhCommand.createOneOfSchema(parentSchema);
        }
        return AbstractSchemaInhCommand.createAllOfSchema(parentSchema);
    }

    protected void copySchemaJsTo(List<ObjectNode> schemas, Schema targetSchema, String inheritanceType) {
        if (NodeUtil.equals(TYPE_ALL_OF, inheritanceType)) {
            schemas.forEach(ser -> AbstractSchemaInhCommand.addAllOfSchema(targetSchema, (Schema)Library.readNode(ser, AbstractSchemaInhCommand.createAllOfSchema(targetSchema))));
        }
        if (NodeUtil.equals(TYPE_ANY_OF, inheritanceType)) {
            schemas.forEach(ser -> AbstractSchemaInhCommand.addAnyOfSchema(targetSchema, (Schema)Library.readNode(ser, AbstractSchemaInhCommand.createAnyOfSchema(targetSchema))));
        }
        if (NodeUtil.equals(TYPE_ONE_OF, inheritanceType)) {
            schemas.forEach(ser -> AbstractSchemaInhCommand.addOneOfSchema(targetSchema, (Schema)Library.readNode(ser, AbstractSchemaInhCommand.createOneOfSchema(targetSchema))));
        }
    }

    private static void addAllOfSchema(Schema to, Schema from) {
        to.addAllOf(from);
    }

    private static Schema createAllOfSchema(Schema schema) {
        return schema.createSchema();
    }

    private static void addAnyOfSchema(Schema to, Schema from) {
        if (ModelTypeUtil.isOpenApi30Model(to)) {
            ((OpenApi30Schema)to).addAnyOf((OpenApi30Schema)from);
        } else if (ModelTypeUtil.isOpenApi31Model(to)) {
            ((OpenApi31Schema)to).addAnyOf((OpenApi31Schema)from);
        } else if (ModelTypeUtil.isAsyncApiModel(to)) {
            ((AsyncApiSchema)to).addAnyOf((AsyncApiSchema)from);
        }
    }

    private static Schema createAnyOfSchema(Schema schema) {
        return schema.createSchema();
    }

    private static void addOneOfSchema(Schema to, Schema from) {
        if (ModelTypeUtil.isOpenApi30Model(to)) {
            ((OpenApi30Schema)to).addOneOf((OpenApi30Schema)from);
        } else if (ModelTypeUtil.isOpenApi31Model(to)) {
            ((OpenApi31Schema)to).addOneOf((OpenApi31Schema)from);
        } else if (ModelTypeUtil.isAsyncApiModel(to)) {
            ((AsyncApiSchema)to).addOneOf((AsyncApiSchema)from);
        }
    }

    private static Schema createOneOfSchema(Schema schema) {
        return schema.createSchema();
    }

    protected boolean has$Ref(Node node) {
        if (node != null && node instanceof Referenceable) {
            String ref = ((Referenceable)((Object)node)).get$ref();
            return !NodeUtil.isNullOrUndefined(ref);
        }
        return false;
    }
}

