/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.MappedNode;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelItem;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannels;
import io.apicurio.datamodels.models.asyncapi.AsyncApiDocument;
import io.apicurio.datamodels.util.LoggerUtil;
import io.apicurio.datamodels.util.NodeUtil;

public class AddChannelItemCommand
extends AbstractCommand {
    public boolean _channelItemExists;
    public boolean _emptyChannelItems;
    public String _newChannelItemName;
    public ObjectNode _newChannelItemObj;

    public AddChannelItemCommand() {
    }

    public AddChannelItemCommand(String channelItemName, ObjectNode from) {
        this._newChannelItemName = channelItemName;
        this._newChannelItemObj = from;
    }

    private boolean isEmptyChannelItems(AsyncApiChannels channels) {
        if (NodeUtil.isNullOrUndefined(channels)) {
            return false;
        }
        return ((MappedNode)((Object)channels)).getItemNames().isEmpty();
    }

    private AsyncApiChannelItem getChannelItem(AsyncApiChannels channels, String name) {
        if (NodeUtil.isNullOrUndefined(channels)) {
            return null;
        }
        return (AsyncApiChannelItem)((MappedNode)((Object)channels)).getItem(name);
    }

    @Override
    public void execute(Document document) {
        AsyncApiChannelItem channelItem;
        LoggerUtil.info("[AddChannelItemCommand] Executing.", new Object[0]);
        AsyncApiDocument doc = (AsyncApiDocument)document;
        if (this.isEmptyChannelItems(doc.getChannels())) {
            this._emptyChannelItems = true;
        }
        if (!NodeUtil.isNullOrUndefined(channelItem = this.getChannelItem(doc.getChannels(), this._newChannelItemName))) {
            LoggerUtil.info("[AddChannelItemCommand] AddChannelItemCommand with name %s already exists.", this._newChannelItemName);
            this._channelItemExists = true;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[AddChannelItemCommand] Reverting.", new Object[0]);
        if (this._channelItemExists) {
            return;
        }
        AsyncApiDocument doc = (AsyncApiDocument)document;
        if (this._emptyChannelItems) {
            doc.setChannels(doc.createChannels());
        } else {
            ((MappedNode)((Object)doc.getChannels())).removeItem(this._newChannelItemName);
        }
    }
}

