/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import io.apicurio.datamodels.util.LoggerUtil;

public class AddPathItemCommand
extends AbstractCommand {
    public boolean _pathItemExists;
    public String _newPathItemName;
    public ObjectNode _newPathItemObj;
    public boolean _nullPathItems;

    public AddPathItemCommand() {
    }

    public AddPathItemCommand(String pathItemName) {
        this._newPathItemName = pathItemName;
    }

    public AddPathItemCommand(String pathItemName, ObjectNode from) {
        this._newPathItemName = pathItemName;
        this._newPathItemObj = from;
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[AddPathItemCommand] Executing.", new Object[0]);
        OpenApiDocument doc = (OpenApiDocument)document;
        if (this.isNullOrUndefined(doc.getPaths())) {
            doc.setPaths(doc.createPaths());
            this._nullPathItems = true;
        }
        if (!this.isNullOrUndefined(doc.getPaths().getItem(this._newPathItemName))) {
            LoggerUtil.info("[AddPathItemCommand] PathItem with name %s already exists.", this._newPathItemName);
            this._pathItemExists = true;
        } else {
            OpenApiPathItem pathItem = doc.getPaths().createPathItem();
            Library.readNode(this._newPathItemObj, pathItem);
            doc.getPaths().addItem(this._newPathItemName, pathItem);
            this._pathItemExists = false;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[AddPathItemCommand] Reverting.", new Object[0]);
        if (this._pathItemExists) {
            return;
        }
        OpenApiDocument doc = (OpenApiDocument)document;
        if (this._nullPathItems) {
            doc.setPaths(null);
        } else {
            doc.getPaths().removeItem(this._newPathItemName);
        }
    }
}

