/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;
import io.apicurio.datamodels.util.NodeUtil;

public class ChangePropertyCommand<T>
extends AbstractCommand {
    public NodePath _nodePath;
    public String _property;
    public T _newValue;
    public T _oldValue;

    public ChangePropertyCommand() {
    }

    public ChangePropertyCommand(Node node, String property, T newValue) {
        if (NodeUtil.isDefined(node)) {
            this._nodePath = NodePathUtil.createNodePath(node);
        }
        this._property = property;
        this._newValue = newValue;
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[ChangePropertyCommand] Executing.", new Object[0]);
        Node node = NodePathUtil.resolveNodePath(this._nodePath, document);
        if (this.isNullOrUndefined(node)) {
            return;
        }
        this._oldValue = NodeUtil.getProperty(node, this._property);
        NodeUtil.setProperty(node, this._property, this._newValue);
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[ChangePropertyCommand] Reverting.", new Object[0]);
        Node node = NodePathUtil.resolveNodePath(this._nodePath, document);
        if (this.isNullOrUndefined(node)) {
            return;
        }
        NodeUtil.setProperty(node, this._property, this._oldValue);
        this._oldValue = null;
    }
}

