/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.util.LoggerUtil;
import io.apicurio.datamodels.util.NodeUtil;

public class ChangeVersionCommand
extends AbstractCommand {
    public String _newVersion;
    public String _oldVersion;
    public boolean _nullInfo;

    public ChangeVersionCommand() {
    }

    public ChangeVersionCommand(String newVersion) {
        this._newVersion = newVersion;
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[ChangeVersionCommand] Executing.", new Object[0]);
        if (NodeUtil.isNullOrUndefined(document.getInfo())) {
            document.setInfo(document.createInfo());
            this._nullInfo = true;
            this._oldVersion = null;
        } else {
            this._oldVersion = document.getInfo().getVersion();
        }
        document.getInfo().setVersion(this._newVersion);
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[ChangeVersionCommand] Reverting.", new Object[0]);
        if (this._nullInfo) {
            document.setInfo(null);
        } else {
            document.getInfo().setVersion(this._oldVersion);
        }
    }
}

