/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Extensible;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public class DeleteAllExtensionsCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public Map<String, JsonNode> _oldExtensions;

    public DeleteAllExtensionsCommand() {
    }

    public DeleteAllExtensionsCommand(Extensible parent) {
        this._parentPath = NodePathUtil.createNodePath((Node)((Object)parent));
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[DeleteAllExtensionsCommand] Executing.", new Object[0]);
        this._oldExtensions = new LinkedHashMap<String, JsonNode>();
        Extensible parent = (Extensible)((Object)NodePathUtil.resolveNodePath(this._parentPath, document));
        Map<String, JsonNode> extensions = parent.getExtensions();
        if (!this.isNullOrUndefined(extensions)) {
            extensions.keySet().forEach(k -> {
                JsonNode value = (JsonNode)extensions.get(k);
                this._oldExtensions.put((String)k, value);
            });
        }
        parent.clearExtensions();
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[DeleteAllExtensionsCommand] Reverting.", new Object[0]);
        if (this._oldExtensions.size() == 0) {
            return;
        }
        Extensible parent = (Extensible)((Object)NodePathUtil.resolveNodePath(this._parentPath, document));
        this._oldExtensions.keySet().forEach(k -> {
            JsonNode value = this._oldExtensions.get(k);
            parent.addExtension((String)k, value);
        });
    }
}

