/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.models.openapi.OpenApiParametersParent;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;
import io.apicurio.datamodels.util.NodeUtil;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllParametersCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public String _paramType;
    public List<ObjectNode> _oldParams;

    public DeleteAllParametersCommand() {
    }

    public DeleteAllParametersCommand(OpenApiParametersParent parent, String type) {
        this._parentPath = Library.createNodePath((Node)((Object)parent));
        this._paramType = type;
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[DeleteAllParameters] Executing.", new Object[0]);
        this._oldParams = new ArrayList<ObjectNode>();
        OpenApiParametersParent parent = (OpenApiParametersParent)((Object)NodePathUtil.resolveNodePath(this._parentPath, document));
        List<OpenApiParameter> parameters = parent.getParameters();
        if (this.isNullOrUndefined(parent) || this.isNullOrUndefined(parameters) || parameters.isEmpty()) {
            return;
        }
        ArrayList<OpenApiParameter> paramsToRemove = new ArrayList<OpenApiParameter>();
        for (OpenApiParameter param : parameters) {
            if (!NodeUtil.equals(param.getIn(), this._paramType)) continue;
            this._oldParams.add(Library.writeNode(param));
            paramsToRemove.add(param);
        }
        if (this._oldParams.isEmpty()) {
            return;
        }
        paramsToRemove.forEach(paramToRemove -> parent.removeParameter((OpenApiParameter)paramToRemove));
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[DeleteAllParameters] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldParams) || this._oldParams.size() == 0) {
            return;
        }
        OpenApiParametersParent parent = (OpenApiParametersParent)((Object)NodePathUtil.resolveNodePath(this._parentPath, document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        this._oldParams.forEach(paramObj -> {
            OpenApiParameter parameter = parent.createParameter();
            Library.readNode(paramObj, parameter);
            parent.addParameter(parameter);
        });
    }
}

