/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.openapi.OpenApiServer;
import io.apicurio.datamodels.models.openapi.OpenApiServersParent;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllServersCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public List<ObjectNode> _oldServers;

    public DeleteAllServersCommand() {
    }

    public DeleteAllServersCommand(OpenApiServersParent parent) {
        this._parentPath = Library.createNodePath((Node)((Object)parent));
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[DeleteAllServersCommand] Executing.", new Object[0]);
        this._oldServers = new ArrayList<ObjectNode>();
        OpenApiServersParent parent = (OpenApiServersParent)((Object)NodePathUtil.resolveNodePath(this._parentPath, document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        List<OpenApiServer> servers = parent.getServers();
        if (!this.isNullOrUndefined(servers)) {
            servers.forEach(server -> this._oldServers.add(Library.writeNode(server)));
        }
        parent.clearServers();
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[DeleteAllServersCommand] Reverting.", new Object[0]);
        if (this._oldServers.isEmpty()) {
            return;
        }
        OpenApiServersParent parent = (OpenApiServersParent)((Object)NodePathUtil.resolveNodePath(this._parentPath, document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        for (ObjectNode oldServer : this._oldServers) {
            OpenApiServer server = parent.createServer();
            Library.readNode(oldServer, server);
            parent.addServer(server);
        }
    }
}

