/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Extensible;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;
import java.util.Map;

public class DeleteExtensionCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public String _name;
    public boolean _hasOldValue;
    public JsonNode _oldValue;
    public int _oldValueIndex;

    public DeleteExtensionCommand() {
    }

    public DeleteExtensionCommand(Extensible parent, String extensionName) {
        this._parentPath = NodePathUtil.createNodePath((Node)((Object)parent));
        this._name = extensionName;
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[DeleteExtensionCommand] Executing.", new Object[0]);
        this._oldValue = null;
        this._hasOldValue = false;
        Node parent = NodePathUtil.resolveNodePath(this._parentPath, document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Extensible extensible = (Extensible)((Object)parent);
        Map<String, JsonNode> extensions = extensible.getExtensions();
        if (this.isNullOrUndefined(extensions)) {
            return;
        }
        if (extensions.containsKey(this._name)) {
            this._hasOldValue = true;
            this._oldValue = extensions.get(this._name);
            this._oldValueIndex = DeleteExtensionCommand.indexOf(extensions.keySet(), this._name);
            extensible.removeExtension(this._name);
        } else {
            this._oldValue = null;
            this._hasOldValue = false;
            this._oldValueIndex = -1;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[DeleteExtensionCommand] Reverting.", new Object[0]);
        if (!this._hasOldValue) {
            return;
        }
        Node parent = NodePathUtil.resolveNodePath(this._parentPath, document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Extensible extensible = (Extensible)((Object)parent);
        if (this._oldValueIndex > -1) {
            extensible.insertExtension(this._name, this._oldValue, this._oldValueIndex);
        } else {
            extensible.addExtension(this._name, this._oldValue);
        }
    }
}

