/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;
import io.apicurio.datamodels.util.NodeUtil;

public abstract class DeleteNodeCommand<T extends Node>
extends AbstractCommand {
    public String _property;
    public NodePath _parentPath;
    public ObjectNode _oldValue;

    public DeleteNodeCommand() {
    }

    public DeleteNodeCommand(String property, Node from) {
        this._property = property;
        this._parentPath = NodePathUtil.createNodePath(from);
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[" + this.type() + "] Executing.", new Object[0]);
        Node parent = NodePathUtil.resolveNodePath(this._parentPath, document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Node propertyNode = (Node)NodeUtil.getProperty(parent, this._property);
        if (this.isNullOrUndefined(propertyNode)) {
            this._oldValue = null;
            return;
        }
        this._oldValue = Library.writeNode(propertyNode);
        NodeUtil.setProperty(parent, this._property, null);
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[" + this.type() + "] Reverting.", new Object[0]);
        Node parent = NodePathUtil.resolveNodePath(this._parentPath, document);
        if (this.isNullOrUndefined(parent) || this.isNullOrUndefined(this._oldValue)) {
            return;
        }
        T restoredNode = this.readNode(document, this._oldValue);
        NodeUtil.setProperty(parent, this._property, restoredNode);
    }

    protected abstract T readNode(Document var1, ObjectNode var2);
}

