/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.asyncapi.v20.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.RootNode;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.AsyncApiMessage;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.asyncapi.AsyncApiTag;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Binding;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ChannelBindings;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ChannelItem;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Channels;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Components;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Contact;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20CorrelationID;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Document;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ExternalDocumentation;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Info;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20License;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Message;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20MessageBindings;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20MessageTrait;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OAuthFlow;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OAuthFlows;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OneOfMessages;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Operation;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OperationBindings;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OperationTrait;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Parameter;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Parameters;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Schema;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20SecurityRequirement;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20SecurityScheme;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Server;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ServerBindings;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ServerVariable;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Servers;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Tag;
import io.apicurio.datamodels.models.io.ModelWriter;
import io.apicurio.datamodels.models.union.Union;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.apicurio.datamodels.models.util.WriterUtil;
import java.util.List;
import java.util.Map;

public class AsyncApi20ModelWriter
implements ModelWriter {
    public void writeDocument(AsyncApi20Document node, ObjectNode json) {
        Map<String, JsonNode> values;
        List<AsyncApi20Tag> models;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "asyncapi", node.getAsyncapi());
        JsonUtil.setStringProperty(json, "id", node.getId());
        if (node.getInfo() != null) {
            object = JsonUtil.objectNode();
            this.writeInfo((AsyncApi20Info)node.getInfo(), object);
            JsonUtil.setObjectProperty(json, "info", object);
        }
        if (node.getServers() != null) {
            object = JsonUtil.objectNode();
            this.writeServers((AsyncApi20Servers)node.getServers(), object);
            JsonUtil.setObjectProperty(json, "servers", object);
        }
        JsonUtil.setStringProperty(json, "defaultContentType", node.getDefaultContentType());
        if (node.getChannels() != null) {
            object = JsonUtil.objectNode();
            this.writeChannels((AsyncApi20Channels)node.getChannels(), object);
            JsonUtil.setObjectProperty(json, "channels", object);
        }
        if (node.getComponents() != null) {
            object = JsonUtil.objectNode();
            this.writeComponents((AsyncApi20Components)node.getComponents(), object);
            JsonUtil.setObjectProperty(json, "components", object);
        }
        if ((models = node.getTags()) != null && !models.isEmpty()) {
            ArrayNode array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi20Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation(node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    @Override
    public ObjectNode writeRoot(RootNode node) {
        ObjectNode json = JsonUtil.objectNode();
        this.writeDocument((AsyncApi20Document)node, json);
        return json;
    }

    public void writeInfo(AsyncApi20Info node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "version", node.getVersion());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "termsOfService", node.getTermsOfService());
        if (node.getContact() != null) {
            object = JsonUtil.objectNode();
            this.writeContact((AsyncApi20Contact)node.getContact(), object);
            JsonUtil.setObjectProperty(json, "contact", object);
        }
        if (node.getLicense() != null) {
            object = JsonUtil.objectNode();
            this.writeLicense((AsyncApi20License)node.getLicense(), object);
            JsonUtil.setObjectProperty(json, "license", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeContact(AsyncApi20Contact node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        JsonUtil.setStringProperty(json, "email", node.getEmail());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeLicense(AsyncApi20License node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServers(AsyncApi20Servers node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writeServer((AsyncApi20Server)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServer(AsyncApi20Server node, ObjectNode json) {
        Map<String, JsonNode> values;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        JsonUtil.setStringProperty(json, "protocol", node.getProtocol());
        JsonUtil.setStringProperty(json, "protocolVersion", node.getProtocolVersion());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        Object models = node.getVariables();
        if (models != null && !models.isEmpty()) {
            ObjectNode object = JsonUtil.objectNode();
            models.keySet().forEach(arg_0 -> this.lambda$writeServer$6((Map)models, object, arg_0));
            JsonUtil.setObjectProperty(json, "variables", object);
        }
        if ((models = node.getSecurity()) != null && !models.isEmpty()) {
            ArrayNode array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSecurityRequirement((AsyncApi20SecurityRequirement)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "security", (JsonNode)array);
        }
        if (node.getBindings() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeServerBindings((AsyncApi20ServerBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServerVariable(AsyncApi20ServerVariable node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringArrayProperty(json, "enum", node.getEnum());
        JsonUtil.setStringProperty(json, "default", node.getDefault());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringArrayProperty(json, "examples", node.getExamples());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeChannels(AsyncApi20Channels node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writeChannelItem((AsyncApi20ChannelItem)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeChannelItem(AsyncApi20ChannelItem node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        if (node.getSubscribe() != null) {
            object = JsonUtil.objectNode();
            this.writeOperation((AsyncApi20Operation)node.getSubscribe(), object);
            JsonUtil.setObjectProperty(json, "subscribe", object);
        }
        if (node.getPublish() != null) {
            object = JsonUtil.objectNode();
            this.writeOperation((AsyncApi20Operation)node.getPublish(), object);
            JsonUtil.setObjectProperty(json, "publish", object);
        }
        if (node.getParameters() != null) {
            object = JsonUtil.objectNode();
            this.writeParameters((AsyncApi20Parameters)node.getParameters(), object);
            JsonUtil.setObjectProperty(json, "parameters", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeChannelBindings((AsyncApi20ChannelBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperation(AsyncApi20Operation node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        ArrayNode array;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "operationId", node.getOperationId());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        List<Node> models = node.getTags();
        if (models != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi20Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi20ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeOperationBindings((AsyncApi20OperationBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((models = node.getTraits()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeOperationTrait((AsyncApi20OperationTrait)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "traits", (JsonNode)array);
        }
        if (node.getMessage() != null) {
            object = JsonUtil.objectNode();
            this.writeMessage(node.getMessage(), object);
            JsonUtil.setObjectProperty(json, "message", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperationTrait(AsyncApi20OperationTrait node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "operationId", node.getOperationId());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        List<AsyncApiTag> models = node.getTags();
        if (models != null && !models.isEmpty()) {
            ArrayNode array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi20Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi20ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeOperationBindings((AsyncApi20OperationBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeParameters(AsyncApi20Parameters node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writeParameter((AsyncApi20Parameter)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeParameter(AsyncApi20Parameter node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        if (node.getSchema() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeSchema(node.getSchema(), object);
            JsonUtil.setObjectProperty(json, "schema", object);
        }
        JsonUtil.setStringProperty(json, "location", node.getLocation());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServerBindings(AsyncApi20ServerBindings node, ObjectNode json) {
        ObjectNode object;
        if (node == null) {
            return;
        }
        if (node.getHttp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getHttp(), object);
            JsonUtil.setObjectProperty(json, "http", object);
        }
        if (node.getWs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getWs(), object);
            JsonUtil.setObjectProperty(json, "ws", object);
        }
        if (node.getKafka() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getKafka(), object);
            JsonUtil.setObjectProperty(json, "kafka", object);
        }
        if (node.getAmqp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getAmqp(), object);
            JsonUtil.setObjectProperty(json, "amqp", object);
        }
        if (node.getAmqp1() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getAmqp1(), object);
            JsonUtil.setObjectProperty(json, "amqp1", object);
        }
        if (node.getMqtt() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getMqtt(), object);
            JsonUtil.setObjectProperty(json, "mqtt", object);
        }
        if (node.getMqtt5() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getMqtt5(), object);
            JsonUtil.setObjectProperty(json, "mqtt5", object);
        }
        if (node.getNats() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getNats(), object);
            JsonUtil.setObjectProperty(json, "nats", object);
        }
        if (node.getJms() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getJms(), object);
            JsonUtil.setObjectProperty(json, "jms", object);
        }
        if (node.getSns() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getSns(), object);
            JsonUtil.setObjectProperty(json, "sns", object);
        }
        if (node.getSqs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getSqs(), object);
            JsonUtil.setObjectProperty(json, "sqs", object);
        }
        if (node.getStomp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getStomp(), object);
            JsonUtil.setObjectProperty(json, "stomp", object);
        }
        if (node.getRedis() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getRedis(), object);
            JsonUtil.setObjectProperty(json, "redis", object);
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeChannelBindings(AsyncApi20ChannelBindings node, ObjectNode json) {
        ObjectNode object;
        if (node == null) {
            return;
        }
        if (node.getHttp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getHttp(), object);
            JsonUtil.setObjectProperty(json, "http", object);
        }
        if (node.getWs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getWs(), object);
            JsonUtil.setObjectProperty(json, "ws", object);
        }
        if (node.getKafka() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getKafka(), object);
            JsonUtil.setObjectProperty(json, "kafka", object);
        }
        if (node.getAmqp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getAmqp(), object);
            JsonUtil.setObjectProperty(json, "amqp", object);
        }
        if (node.getAmqp1() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getAmqp1(), object);
            JsonUtil.setObjectProperty(json, "amqp1", object);
        }
        if (node.getMqtt() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getMqtt(), object);
            JsonUtil.setObjectProperty(json, "mqtt", object);
        }
        if (node.getMqtt5() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getMqtt5(), object);
            JsonUtil.setObjectProperty(json, "mqtt5", object);
        }
        if (node.getNats() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getNats(), object);
            JsonUtil.setObjectProperty(json, "nats", object);
        }
        if (node.getJms() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getJms(), object);
            JsonUtil.setObjectProperty(json, "jms", object);
        }
        if (node.getSns() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getSns(), object);
            JsonUtil.setObjectProperty(json, "sns", object);
        }
        if (node.getSqs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getSqs(), object);
            JsonUtil.setObjectProperty(json, "sqs", object);
        }
        if (node.getStomp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getStomp(), object);
            JsonUtil.setObjectProperty(json, "stomp", object);
        }
        if (node.getRedis() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getRedis(), object);
            JsonUtil.setObjectProperty(json, "redis", object);
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperationBindings(AsyncApi20OperationBindings node, ObjectNode json) {
        ObjectNode object;
        if (node == null) {
            return;
        }
        if (node.getHttp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getHttp(), object);
            JsonUtil.setObjectProperty(json, "http", object);
        }
        if (node.getWs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getWs(), object);
            JsonUtil.setObjectProperty(json, "ws", object);
        }
        if (node.getKafka() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getKafka(), object);
            JsonUtil.setObjectProperty(json, "kafka", object);
        }
        if (node.getAmqp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getAmqp(), object);
            JsonUtil.setObjectProperty(json, "amqp", object);
        }
        if (node.getAmqp1() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getAmqp1(), object);
            JsonUtil.setObjectProperty(json, "amqp1", object);
        }
        if (node.getMqtt() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getMqtt(), object);
            JsonUtil.setObjectProperty(json, "mqtt", object);
        }
        if (node.getMqtt5() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getMqtt5(), object);
            JsonUtil.setObjectProperty(json, "mqtt5", object);
        }
        if (node.getNats() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getNats(), object);
            JsonUtil.setObjectProperty(json, "nats", object);
        }
        if (node.getJms() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getJms(), object);
            JsonUtil.setObjectProperty(json, "jms", object);
        }
        if (node.getSns() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getSns(), object);
            JsonUtil.setObjectProperty(json, "sns", object);
        }
        if (node.getSqs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getSqs(), object);
            JsonUtil.setObjectProperty(json, "sqs", object);
        }
        if (node.getStomp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getStomp(), object);
            JsonUtil.setObjectProperty(json, "stomp", object);
        }
        if (node.getRedis() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getRedis(), object);
            JsonUtil.setObjectProperty(json, "redis", object);
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMessageBindings(AsyncApi20MessageBindings node, ObjectNode json) {
        ObjectNode object;
        if (node == null) {
            return;
        }
        if (node.getHttp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getHttp(), object);
            JsonUtil.setObjectProperty(json, "http", object);
        }
        if (node.getWs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getWs(), object);
            JsonUtil.setObjectProperty(json, "ws", object);
        }
        if (node.getKafka() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getKafka(), object);
            JsonUtil.setObjectProperty(json, "kafka", object);
        }
        if (node.getAmqp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getAmqp(), object);
            JsonUtil.setObjectProperty(json, "amqp", object);
        }
        if (node.getAmqp1() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getAmqp1(), object);
            JsonUtil.setObjectProperty(json, "amqp1", object);
        }
        if (node.getMqtt() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getMqtt(), object);
            JsonUtil.setObjectProperty(json, "mqtt", object);
        }
        if (node.getMqtt5() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getMqtt5(), object);
            JsonUtil.setObjectProperty(json, "mqtt5", object);
        }
        if (node.getNats() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getNats(), object);
            JsonUtil.setObjectProperty(json, "nats", object);
        }
        if (node.getJms() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getJms(), object);
            JsonUtil.setObjectProperty(json, "jms", object);
        }
        if (node.getSns() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getSns(), object);
            JsonUtil.setObjectProperty(json, "sns", object);
        }
        if (node.getSqs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getSqs(), object);
            JsonUtil.setObjectProperty(json, "sqs", object);
        }
        if (node.getStomp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getStomp(), object);
            JsonUtil.setObjectProperty(json, "stomp", object);
        }
        if (node.getRedis() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi20Binding)node.getRedis(), object);
            JsonUtil.setObjectProperty(json, "redis", object);
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOneOfMessages(AsyncApi20OneOfMessages node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<AsyncApiMessage> models = node.getOneOf();
        if (models != null && !models.isEmpty()) {
            ArrayNode array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeMessage((AsyncApi20Message)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "oneOf", (JsonNode)array);
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMessage(AsyncApi20Message node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        ArrayNode array;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        List<Node> models = node.getOneOf();
        if (models != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeMessage((AsyncApi20Message)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "oneOf", (JsonNode)array);
        }
        if (node.getHeaders() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema(node.getHeaders(), object);
            JsonUtil.setObjectProperty(json, "headers", object);
        }
        JsonUtil.setAnyProperty(json, "payload", node.getPayload());
        if (node.getCorrelationId() != null) {
            object = JsonUtil.objectNode();
            this.writeCorrelationID((AsyncApi20CorrelationID)node.getCorrelationId(), object);
            JsonUtil.setObjectProperty(json, "correlationId", object);
        }
        JsonUtil.setStringProperty(json, "schemaFormat", node.getSchemaFormat());
        JsonUtil.setStringProperty(json, "contentType", node.getContentType());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        models = node.getTags();
        if (models != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi20Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi20ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeMessageBindings((AsyncApi20MessageBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        JsonUtil.setAnyMapProperty(json, "examples", node.getExamples());
        models = node.getTraits();
        if (models != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeMessageTrait((AsyncApi20MessageTrait)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "traits", (JsonNode)array);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMessageTrait(AsyncApi20MessageTrait node, ObjectNode json) {
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        if (node.getHeaders() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema(node.getHeaders(), object);
            JsonUtil.setObjectProperty(json, "headers", object);
        }
        if (node.getCorrelationId() != null) {
            object = JsonUtil.objectNode();
            this.writeCorrelationID((AsyncApi20CorrelationID)node.getCorrelationId(), object);
            JsonUtil.setObjectProperty(json, "correlationId", object);
        }
        JsonUtil.setStringProperty(json, "schemaFormat", node.getSchemaFormat());
        JsonUtil.setStringProperty(json, "contentType", node.getContentType());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        List<AsyncApiTag> models = node.getTags();
        if (models != null && !models.isEmpty()) {
            ArrayNode array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi20Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi20ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeMessageBindings((AsyncApi20MessageBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        JsonUtil.setAnyMapProperty(json, "examples", node.getExamples());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeTag(AsyncApi20Tag node, ObjectNode json) {
        Map<String, JsonNode> values;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        if (node.getExternalDocs() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi20ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeExternalDocumentation(AsyncApi20ExternalDocumentation node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeComponents(AsyncApi20Components node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        Map<String, Node> models = node.getSchemas();
        if (models != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi20Schema)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "schemas", object);
        }
        if ((models = node.getMessages()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMessage((AsyncApi20Message)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "messages", object);
        }
        if ((models = node.getSecuritySchemes()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSecurityScheme((AsyncApi20SecurityScheme)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "securitySchemes", object);
        }
        if ((models = node.getParameters()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeParameter((AsyncApi20Parameter)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "parameters", object);
        }
        if ((models = node.getCorrelationIds()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeCorrelationID((AsyncApi20CorrelationID)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "correlationIds", object);
        }
        if ((models = node.getOperationTraits()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeOperationTrait((AsyncApi20OperationTrait)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "operationTraits", object);
        }
        if ((models = node.getMessageTraits()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMessageTrait((AsyncApi20MessageTrait)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "messageTraits", object);
        }
        if ((models = node.getServerBindings()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeServerBindings((AsyncApi20ServerBindings)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "serverBindings", object);
        }
        if ((models = node.getChannelBindings()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeChannelBindings((AsyncApi20ChannelBindings)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "channelBindings", object);
        }
        if ((models = node.getOperationBindings()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeOperationBindings((AsyncApi20OperationBindings)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "operationBindings", object);
        }
        if ((models = node.getMessageBindings()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMessageBindings((AsyncApi20MessageBindings)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "messageBindings", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeSchema(AsyncApi20Schema node, ObjectNode json) {
        ArrayNode array;
        ObjectNode jsonValue;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "type", node.getType());
        JsonUtil.setStringArrayProperty(json, "required", node.getRequired());
        JsonUtil.setNumberProperty(json, "multipleOf", node.getMultipleOf());
        JsonUtil.setNumberProperty(json, "maximum", node.getMaximum());
        JsonUtil.setNumberProperty(json, "exclusiveMaximum", node.getExclusiveMaximum());
        JsonUtil.setNumberProperty(json, "minimum", node.getMinimum());
        JsonUtil.setNumberProperty(json, "exclusiveMinimum", node.getExclusiveMinimum());
        JsonUtil.setIntegerProperty(json, "maxLength", node.getMaxLength());
        JsonUtil.setIntegerProperty(json, "minLength", node.getMinLength());
        JsonUtil.setStringProperty(json, "pattern", node.getPattern());
        JsonUtil.setIntegerProperty(json, "maxItems", node.getMaxItems());
        JsonUtil.setIntegerProperty(json, "minItems", node.getMinItems());
        JsonUtil.setBooleanProperty(json, "uniqueItems", node.isUniqueItems());
        JsonUtil.setIntegerProperty(json, "maxProperties", node.getMaxProperties());
        JsonUtil.setIntegerProperty(json, "minProperties", node.getMinProperties());
        JsonUtil.setAnyArrayProperty(json, "enum", node.getEnum());
        JsonUtil.setAnyProperty(json, "const", node.getConst());
        JsonUtil.setAnyArrayProperty(json, "examples", node.getExamples());
        if (node.getIf() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi20Schema)node.getIf(), object);
            JsonUtil.setObjectProperty(json, "if", object);
        }
        if (node.getThen() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi20Schema)node.getThen(), object);
            JsonUtil.setObjectProperty(json, "then", object);
        }
        if (node.getElse() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi20Schema)node.getElse(), object);
            JsonUtil.setObjectProperty(json, "else", object);
        }
        JsonUtil.setBooleanProperty(json, "readOnly", node.isReadOnly());
        JsonUtil.setBooleanProperty(json, "writeOnly", node.isWriteOnly());
        List<AsyncApiSchema> models = node.getProperties();
        if (models != null && !models.isEmpty()) {
            ObjectNode object2 = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi20Schema)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object2, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "properties", object2);
        }
        JsonUtil.setStringMapProperty(json, "patternProperties", node.getPatternProperties());
        Union union = node.getAdditionalProperties();
        if (union != null) {
            if (union.isBoolean()) {
                JsonUtil.setBooleanProperty(json, "additionalProperties", union.asBoolean());
            }
            if (union.isSchema()) {
                jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi20Schema)union.asSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "additionalProperties", jsonValue);
            }
        }
        if (node.getAdditionalItems() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi20Schema)node.getAdditionalItems(), object);
            JsonUtil.setObjectProperty(json, "additionalItems", object);
        }
        if ((union = node.getItems()) != null) {
            if (union.isSchema()) {
                jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi20Schema)union.asSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "items", jsonValue);
            }
            if (union.isSchemaList()) {
                List<Schema> models2 = union.asSchemaList();
                ArrayNode array2 = JsonUtil.arrayNode();
                models2.forEach(model -> {
                    ObjectNode object = JsonUtil.objectNode();
                    this.writeSchema((AsyncApi20Schema)model, object);
                    JsonUtil.addToArray(array2, (JsonNode)object);
                });
                JsonUtil.setAnyProperty(json, "items", (JsonNode)array2);
            }
        }
        if (node.getPropertyNames() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi20Schema)node.getPropertyNames(), object);
            JsonUtil.setObjectProperty(json, "propertyNames", object);
        }
        if (node.getContains() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi20Schema)node.getContains(), object);
            JsonUtil.setObjectProperty(json, "contains", object);
        }
        if ((models = node.getAllOf()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSchema((AsyncApi20Schema)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "allOf", (JsonNode)array);
        }
        if ((models = node.getOneOf()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSchema((AsyncApi20Schema)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "oneOf", (JsonNode)array);
        }
        if ((models = node.getAnyOf()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSchema((AsyncApi20Schema)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "anyOf", (JsonNode)array);
        }
        if (node.getNot() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi20Schema)node.getNot(), object);
            JsonUtil.setObjectProperty(json, "not", object);
        }
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "format", node.getFormat());
        JsonUtil.setAnyProperty(json, "default", node.getDefault());
        JsonUtil.setStringProperty(json, "discriminator", node.getDiscriminator());
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi20ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        JsonUtil.setBooleanProperty(json, "deprecated", node.isDeprecated());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeSecurityScheme(AsyncApi20SecurityScheme node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "type", node.getType());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "in", node.getIn());
        JsonUtil.setStringProperty(json, "scheme", node.getScheme());
        JsonUtil.setStringProperty(json, "bearerFormat", node.getBearerFormat());
        if (node.getFlows() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeOAuthFlows((AsyncApi20OAuthFlows)node.getFlows(), object);
            JsonUtil.setObjectProperty(json, "flows", object);
        }
        JsonUtil.setStringProperty(json, "openIdConnectUrl", node.getOpenIdConnectUrl());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOAuthFlows(AsyncApi20OAuthFlows node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        if (node.getImplicit() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((AsyncApi20OAuthFlow)node.getImplicit(), object);
            JsonUtil.setObjectProperty(json, "implicit", object);
        }
        if (node.getPassword() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((AsyncApi20OAuthFlow)node.getPassword(), object);
            JsonUtil.setObjectProperty(json, "password", object);
        }
        if (node.getClientCredentials() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((AsyncApi20OAuthFlow)node.getClientCredentials(), object);
            JsonUtil.setObjectProperty(json, "clientCredentials", object);
        }
        if (node.getAuthorizationCode() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((AsyncApi20OAuthFlow)node.getAuthorizationCode(), object);
            JsonUtil.setObjectProperty(json, "authorizationCode", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOAuthFlow(AsyncApi20OAuthFlow node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "authorizationUrl", node.getAuthorizationUrl());
        JsonUtil.setStringProperty(json, "tokenUrl", node.getTokenUrl());
        JsonUtil.setStringProperty(json, "refreshUrl", node.getRefreshUrl());
        JsonUtil.setStringMapProperty(json, "scopes", node.getScopes());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeSecurityRequirement(AsyncApi20SecurityRequirement node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            List value = (List)node.getItem((String)propertyName);
            JsonUtil.setStringArrayProperty(json, propertyName, value);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeCorrelationID(AsyncApi20CorrelationID node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "location", node.getLocation());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeBinding(AsyncApi20Binding node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            JsonNode value = (JsonNode)node.getItem((String)propertyName);
            JsonUtil.setAnyProperty(json, propertyName, value);
        });
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    private /* synthetic */ void lambda$writeServer$6(Map models, ObjectNode object, String jsonName) {
        ObjectNode jsonValue = JsonUtil.objectNode();
        this.writeServerVariable((AsyncApi20ServerVariable)models.get(jsonName), jsonValue);
        JsonUtil.setObjectProperty(object, jsonName, jsonValue);
    }
}

