/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.asyncapi.v30.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.RootNode;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Binding;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Channel;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30ChannelBindings;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Channels;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Components;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Contact;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30CorrelationID;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Document;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30ExternalDocumentation;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Info;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30License;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Message;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30MessageBindings;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30MessageExample;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30MessageTrait;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30MultiFormatSchema;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30OAuthFlow;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30OAuthFlows;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Operation;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30OperationBindings;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30OperationReply;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30OperationReplyAddress;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30OperationTrait;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Operations;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Parameter;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Parameters;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Reference;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Schema;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30SecurityScheme;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Server;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30ServerBindings;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30ServerVariable;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Servers;
import io.apicurio.datamodels.models.asyncapi.v30.AsyncApi30Tag;
import io.apicurio.datamodels.models.io.ModelWriter;
import io.apicurio.datamodels.models.union.AnySchemaUnion;
import io.apicurio.datamodels.models.union.MultiFormatSchemaSchemaUnion;
import io.apicurio.datamodels.models.union.Union;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.apicurio.datamodels.models.util.WriterUtil;
import java.util.List;
import java.util.Map;

public class AsyncApi30ModelWriter
implements ModelWriter {
    public void writeDocument(AsyncApi30Document node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "asyncapi", node.getAsyncapi());
        JsonUtil.setStringProperty(json, "id", node.getId());
        if (node.getInfo() != null) {
            object = JsonUtil.objectNode();
            this.writeInfo((AsyncApi30Info)node.getInfo(), object);
            JsonUtil.setObjectProperty(json, "info", object);
        }
        if (node.getServers() != null) {
            object = JsonUtil.objectNode();
            this.writeServers((AsyncApi30Servers)node.getServers(), object);
            JsonUtil.setObjectProperty(json, "servers", object);
        }
        JsonUtil.setStringProperty(json, "defaultContentType", node.getDefaultContentType());
        if (node.getChannels() != null) {
            object = JsonUtil.objectNode();
            this.writeChannels((AsyncApi30Channels)node.getChannels(), object);
            JsonUtil.setObjectProperty(json, "channels", object);
        }
        if (node.getOperations() != null) {
            object = JsonUtil.objectNode();
            this.writeOperations(node.getOperations(), object);
            JsonUtil.setObjectProperty(json, "operations", object);
        }
        if (node.getComponents() != null) {
            object = JsonUtil.objectNode();
            this.writeComponents((AsyncApi30Components)node.getComponents(), object);
            JsonUtil.setObjectProperty(json, "components", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    @Override
    public ObjectNode writeRoot(RootNode node) {
        ObjectNode json = JsonUtil.objectNode();
        this.writeDocument((AsyncApi30Document)node, json);
        return json;
    }

    public void writeInfo(AsyncApi30Info node, ObjectNode json) {
        Map<String, JsonNode> values;
        List<AsyncApi30Tag> models;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "version", node.getVersion());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "termsOfService", node.getTermsOfService());
        if (node.getContact() != null) {
            object = JsonUtil.objectNode();
            this.writeContact((AsyncApi30Contact)node.getContact(), object);
            JsonUtil.setObjectProperty(json, "contact", object);
        }
        if (node.getLicense() != null) {
            object = JsonUtil.objectNode();
            this.writeLicense((AsyncApi30License)node.getLicense(), object);
            JsonUtil.setObjectProperty(json, "license", object);
        }
        if ((models = node.getTags()) != null && !models.isEmpty()) {
            ArrayNode array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi30Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation(node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeContact(AsyncApi30Contact node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        JsonUtil.setStringProperty(json, "email", node.getEmail());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeLicense(AsyncApi30License node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServers(AsyncApi30Servers node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writeServer((AsyncApi30Server)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServer(AsyncApi30Server node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        ArrayNode array;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "host", node.getHost());
        JsonUtil.setStringProperty(json, "protocol", node.getProtocol());
        JsonUtil.setStringProperty(json, "protocolVersion", node.getProtocolVersion());
        JsonUtil.setStringProperty(json, "pathname", node.getPathname());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        List<AsyncApi30Tag> models = node.getVariables();
        if (models != null && !models.isEmpty()) {
            ObjectNode object2 = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeServerVariable((AsyncApi30ServerVariable)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object2, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "variables", object2);
        }
        if ((models = node.getSecurity()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSecurityScheme((AsyncApi30SecurityScheme)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "security", (JsonNode)array);
        }
        if ((models = node.getTags()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi30Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation(node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeServerBindings((AsyncApi30ServerBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServerVariable(AsyncApi30ServerVariable node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringArrayProperty(json, "enum", node.getEnum());
        JsonUtil.setStringProperty(json, "default", node.getDefault());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringArrayProperty(json, "examples", node.getExamples());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeChannels(AsyncApi30Channels node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writeChannel((AsyncApi30Channel)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeChannel(AsyncApi30Channel node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        ArrayNode array;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "address", node.getAddress());
        List<AsyncApi30Tag> models = node.getMessages();
        if (models != null && !models.isEmpty()) {
            ObjectNode object2 = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMessage((AsyncApi30Message)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object2, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "messages", object2);
        }
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        models = node.getServers();
        if (models != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeReference((AsyncApi30Reference)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "servers", (JsonNode)array);
        }
        if (node.getParameters() != null) {
            object = JsonUtil.objectNode();
            this.writeParameters(node.getParameters(), object);
            JsonUtil.setObjectProperty(json, "parameters", object);
        }
        if ((models = node.getTags()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi30Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation(node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeChannelBindings(node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperations(AsyncApi30Operations node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writeOperation((AsyncApi30Operation)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperation(AsyncApi30Operation node, ObjectNode json) {
        Map<String, JsonNode> values;
        ArrayNode array;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "action", node.getAction());
        if (node.getChannel() != null) {
            object = JsonUtil.objectNode();
            this.writeReference(node.getChannel(), object);
            JsonUtil.setObjectProperty(json, "channel", object);
        }
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        List<Node> models = node.getSecurity();
        if (models != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSecurityScheme((AsyncApi30SecurityScheme)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "security", (JsonNode)array);
        }
        if ((models = node.getTags()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi30Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi30ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeOperationBindings((AsyncApi30OperationBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((models = node.getTraits()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeOperationTrait((AsyncApi30OperationTrait)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "traits", (JsonNode)array);
        }
        if ((models = node.getMessages()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeReference((AsyncApi30Reference)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "messages", (JsonNode)array);
        }
        if (node.getReply() != null) {
            object = JsonUtil.objectNode();
            this.writeOperationReply(node.getReply(), object);
            JsonUtil.setObjectProperty(json, "reply", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperationTrait(AsyncApi30OperationTrait node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        ArrayNode array;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        List<Node> models = node.getSecurity();
        if (models != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSecurityScheme((AsyncApi30SecurityScheme)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "security", (JsonNode)array);
        }
        if ((models = node.getTags()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi30Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi30ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeOperationBindings((AsyncApi30OperationBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperationReply(AsyncApi30OperationReply node, ObjectNode json) {
        Map<String, JsonNode> values;
        List<AsyncApi30Reference> models;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        if (node.getAddress() != null) {
            object = JsonUtil.objectNode();
            this.writeOperationReplyAddress(node.getAddress(), object);
            JsonUtil.setObjectProperty(json, "address", object);
        }
        if (node.getChannel() != null) {
            object = JsonUtil.objectNode();
            this.writeReference(node.getChannel(), object);
            JsonUtil.setObjectProperty(json, "channel", object);
        }
        if ((models = node.getMessages()) != null && !models.isEmpty()) {
            ArrayNode array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeReference((AsyncApi30Reference)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "messages", (JsonNode)array);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperationReplyAddress(AsyncApi30OperationReplyAddress node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "location", node.getLocation());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeParameters(AsyncApi30Parameters node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writeParameter((AsyncApi30Parameter)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeParameter(AsyncApi30Parameter node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringArrayProperty(json, "enum", node.getEnum());
        JsonUtil.setStringProperty(json, "default", node.getDefault());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringArrayProperty(json, "examples", node.getExamples());
        JsonUtil.setStringProperty(json, "location", node.getLocation());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServerBindings(AsyncApi30ServerBindings node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        if (node.getHttp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getHttp(), object);
            JsonUtil.setObjectProperty(json, "http", object);
        }
        if (node.getWs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getWs(), object);
            JsonUtil.setObjectProperty(json, "ws", object);
        }
        if (node.getKafka() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getKafka(), object);
            JsonUtil.setObjectProperty(json, "kafka", object);
        }
        if (node.getAnypointmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getAnypointmq(), object);
            JsonUtil.setObjectProperty(json, "anypointmq", object);
        }
        if (node.getAmqp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getAmqp(), object);
            JsonUtil.setObjectProperty(json, "amqp", object);
        }
        if (node.getAmqp1() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getAmqp1(), object);
            JsonUtil.setObjectProperty(json, "amqp1", object);
        }
        if (node.getMqtt() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getMqtt(), object);
            JsonUtil.setObjectProperty(json, "mqtt", object);
        }
        if (node.getMqtt5() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getMqtt5(), object);
            JsonUtil.setObjectProperty(json, "mqtt5", object);
        }
        if (node.getNats() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getNats(), object);
            JsonUtil.setObjectProperty(json, "nats", object);
        }
        if (node.getJms() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getJms(), object);
            JsonUtil.setObjectProperty(json, "jms", object);
        }
        if (node.getSns() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getSns(), object);
            JsonUtil.setObjectProperty(json, "sns", object);
        }
        if (node.getSolace() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getSolace(), object);
            JsonUtil.setObjectProperty(json, "solace", object);
        }
        if (node.getSqs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getSqs(), object);
            JsonUtil.setObjectProperty(json, "sqs", object);
        }
        if (node.getStomp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getStomp(), object);
            JsonUtil.setObjectProperty(json, "stomp", object);
        }
        if (node.getRedis() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getRedis(), object);
            JsonUtil.setObjectProperty(json, "redis", object);
        }
        if (node.getMercure() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getMercure(), object);
            JsonUtil.setObjectProperty(json, "mercure", object);
        }
        if (node.getIbmmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getIbmmq(), object);
            JsonUtil.setObjectProperty(json, "ibmmq", object);
        }
        if (node.getGooglepubsub() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getGooglepubsub(), object);
            JsonUtil.setObjectProperty(json, "googlepubsub", object);
        }
        if (node.getPulsar() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getPulsar(), object);
            JsonUtil.setObjectProperty(json, "pulsar", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeChannelBindings(AsyncApi30ChannelBindings node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        if (node.getHttp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getHttp(), object);
            JsonUtil.setObjectProperty(json, "http", object);
        }
        if (node.getWs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getWs(), object);
            JsonUtil.setObjectProperty(json, "ws", object);
        }
        if (node.getKafka() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getKafka(), object);
            JsonUtil.setObjectProperty(json, "kafka", object);
        }
        if (node.getAnypointmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getAnypointmq(), object);
            JsonUtil.setObjectProperty(json, "anypointmq", object);
        }
        if (node.getAmqp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getAmqp(), object);
            JsonUtil.setObjectProperty(json, "amqp", object);
        }
        if (node.getAmqp1() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getAmqp1(), object);
            JsonUtil.setObjectProperty(json, "amqp1", object);
        }
        if (node.getMqtt() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getMqtt(), object);
            JsonUtil.setObjectProperty(json, "mqtt", object);
        }
        if (node.getMqtt5() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getMqtt5(), object);
            JsonUtil.setObjectProperty(json, "mqtt5", object);
        }
        if (node.getNats() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getNats(), object);
            JsonUtil.setObjectProperty(json, "nats", object);
        }
        if (node.getJms() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getJms(), object);
            JsonUtil.setObjectProperty(json, "jms", object);
        }
        if (node.getSns() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getSns(), object);
            JsonUtil.setObjectProperty(json, "sns", object);
        }
        if (node.getSolace() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getSolace(), object);
            JsonUtil.setObjectProperty(json, "solace", object);
        }
        if (node.getSqs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getSqs(), object);
            JsonUtil.setObjectProperty(json, "sqs", object);
        }
        if (node.getStomp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getStomp(), object);
            JsonUtil.setObjectProperty(json, "stomp", object);
        }
        if (node.getRedis() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getRedis(), object);
            JsonUtil.setObjectProperty(json, "redis", object);
        }
        if (node.getMercure() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getMercure(), object);
            JsonUtil.setObjectProperty(json, "mercure", object);
        }
        if (node.getIbmmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getIbmmq(), object);
            JsonUtil.setObjectProperty(json, "ibmmq", object);
        }
        if (node.getGooglepubsub() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getGooglepubsub(), object);
            JsonUtil.setObjectProperty(json, "googlepubsub", object);
        }
        if (node.getPulsar() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getPulsar(), object);
            JsonUtil.setObjectProperty(json, "pulsar", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperationBindings(AsyncApi30OperationBindings node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        if (node.getHttp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getHttp(), object);
            JsonUtil.setObjectProperty(json, "http", object);
        }
        if (node.getWs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getWs(), object);
            JsonUtil.setObjectProperty(json, "ws", object);
        }
        if (node.getKafka() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getKafka(), object);
            JsonUtil.setObjectProperty(json, "kafka", object);
        }
        if (node.getAnypointmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getAnypointmq(), object);
            JsonUtil.setObjectProperty(json, "anypointmq", object);
        }
        if (node.getAmqp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getAmqp(), object);
            JsonUtil.setObjectProperty(json, "amqp", object);
        }
        if (node.getAmqp1() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getAmqp1(), object);
            JsonUtil.setObjectProperty(json, "amqp1", object);
        }
        if (node.getMqtt() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getMqtt(), object);
            JsonUtil.setObjectProperty(json, "mqtt", object);
        }
        if (node.getMqtt5() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getMqtt5(), object);
            JsonUtil.setObjectProperty(json, "mqtt5", object);
        }
        if (node.getNats() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getNats(), object);
            JsonUtil.setObjectProperty(json, "nats", object);
        }
        if (node.getJms() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getJms(), object);
            JsonUtil.setObjectProperty(json, "jms", object);
        }
        if (node.getSns() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getSns(), object);
            JsonUtil.setObjectProperty(json, "sns", object);
        }
        if (node.getSolace() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getSolace(), object);
            JsonUtil.setObjectProperty(json, "solace", object);
        }
        if (node.getSqs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getSqs(), object);
            JsonUtil.setObjectProperty(json, "sqs", object);
        }
        if (node.getStomp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getStomp(), object);
            JsonUtil.setObjectProperty(json, "stomp", object);
        }
        if (node.getRedis() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getRedis(), object);
            JsonUtil.setObjectProperty(json, "redis", object);
        }
        if (node.getMercure() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getMercure(), object);
            JsonUtil.setObjectProperty(json, "mercure", object);
        }
        if (node.getIbmmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getIbmmq(), object);
            JsonUtil.setObjectProperty(json, "ibmmq", object);
        }
        if (node.getGooglepubsub() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getGooglepubsub(), object);
            JsonUtil.setObjectProperty(json, "googlepubsub", object);
        }
        if (node.getPulsar() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getPulsar(), object);
            JsonUtil.setObjectProperty(json, "pulsar", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMessageBindings(AsyncApi30MessageBindings node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        if (node.getHttp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getHttp(), object);
            JsonUtil.setObjectProperty(json, "http", object);
        }
        if (node.getWs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getWs(), object);
            JsonUtil.setObjectProperty(json, "ws", object);
        }
        if (node.getKafka() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getKafka(), object);
            JsonUtil.setObjectProperty(json, "kafka", object);
        }
        if (node.getAnypointmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getAnypointmq(), object);
            JsonUtil.setObjectProperty(json, "anypointmq", object);
        }
        if (node.getAmqp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getAmqp(), object);
            JsonUtil.setObjectProperty(json, "amqp", object);
        }
        if (node.getAmqp1() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getAmqp1(), object);
            JsonUtil.setObjectProperty(json, "amqp1", object);
        }
        if (node.getMqtt() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getMqtt(), object);
            JsonUtil.setObjectProperty(json, "mqtt", object);
        }
        if (node.getMqtt5() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getMqtt5(), object);
            JsonUtil.setObjectProperty(json, "mqtt5", object);
        }
        if (node.getNats() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getNats(), object);
            JsonUtil.setObjectProperty(json, "nats", object);
        }
        if (node.getJms() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getJms(), object);
            JsonUtil.setObjectProperty(json, "jms", object);
        }
        if (node.getSns() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getSns(), object);
            JsonUtil.setObjectProperty(json, "sns", object);
        }
        if (node.getSolace() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getSolace(), object);
            JsonUtil.setObjectProperty(json, "solace", object);
        }
        if (node.getSqs() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getSqs(), object);
            JsonUtil.setObjectProperty(json, "sqs", object);
        }
        if (node.getStomp() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getStomp(), object);
            JsonUtil.setObjectProperty(json, "stomp", object);
        }
        if (node.getRedis() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding((AsyncApi30Binding)node.getRedis(), object);
            JsonUtil.setObjectProperty(json, "redis", object);
        }
        if (node.getMercure() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getMercure(), object);
            JsonUtil.setObjectProperty(json, "mercure", object);
        }
        if (node.getIbmmq() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getIbmmq(), object);
            JsonUtil.setObjectProperty(json, "ibmmq", object);
        }
        if (node.getGooglepubsub() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getGooglepubsub(), object);
            JsonUtil.setObjectProperty(json, "googlepubsub", object);
        }
        if (node.getPulsar() != null) {
            object = JsonUtil.objectNode();
            this.writeBinding(node.getPulsar(), object);
            JsonUtil.setObjectProperty(json, "pulsar", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMessage(AsyncApi30Message node, ObjectNode json) {
        Map<String, JsonNode> values;
        ArrayNode array;
        ObjectNode object;
        ObjectNode jsonValue;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        MultiFormatSchemaSchemaUnion union = node.getHeaders();
        if (union != null) {
            if (union.isMultiFormatSchema()) {
                jsonValue = JsonUtil.objectNode();
                this.writeMultiFormatSchema(union.asMultiFormatSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "headers", jsonValue);
            }
            if (union.isSchema()) {
                jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi30Schema)union.asSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "headers", jsonValue);
            }
        }
        if ((union = node.getPayload()) != null) {
            if (union.isMultiFormatSchema()) {
                jsonValue = JsonUtil.objectNode();
                this.writeMultiFormatSchema(union.asMultiFormatSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "payload", jsonValue);
            }
            if (union.isSchema()) {
                jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi30Schema)union.asSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "payload", jsonValue);
            }
        }
        if (node.getCorrelationId() != null) {
            object = JsonUtil.objectNode();
            this.writeCorrelationID((AsyncApi30CorrelationID)node.getCorrelationId(), object);
            JsonUtil.setObjectProperty(json, "correlationId", object);
        }
        JsonUtil.setStringProperty(json, "contentType", node.getContentType());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        List<Node> models = node.getTags();
        if (models != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi30Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi30ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeMessageBindings((AsyncApi30MessageBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((models = node.getExamples()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeMessageExample((AsyncApi30MessageExample)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "examples", (JsonNode)array);
        }
        if ((models = node.getTraits()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeMessageTrait((AsyncApi30MessageTrait)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "traits", (JsonNode)array);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMessageTrait(AsyncApi30MessageTrait node, ObjectNode json) {
        Map<String, JsonNode> values;
        ArrayNode array;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        MultiFormatSchemaSchemaUnion union = node.getHeaders();
        if (union != null) {
            ObjectNode jsonValue;
            if (union.isMultiFormatSchema()) {
                jsonValue = JsonUtil.objectNode();
                this.writeMultiFormatSchema(union.asMultiFormatSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "headers", jsonValue);
            }
            if (union.isSchema()) {
                jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi30Schema)union.asSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "headers", jsonValue);
            }
        }
        if (node.getCorrelationId() != null) {
            object = JsonUtil.objectNode();
            this.writeCorrelationID((AsyncApi30CorrelationID)node.getCorrelationId(), object);
            JsonUtil.setObjectProperty(json, "correlationId", object);
        }
        JsonUtil.setStringProperty(json, "contentType", node.getContentType());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        List<Node> models = node.getTags();
        if (models != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((AsyncApi30Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi30ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if (node.getBindings() != null) {
            object = JsonUtil.objectNode();
            this.writeMessageBindings((AsyncApi30MessageBindings)node.getBindings(), object);
            JsonUtil.setObjectProperty(json, "bindings", object);
        }
        if ((models = node.getExamples()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeMessageExample((AsyncApi30MessageExample)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "examples", (JsonNode)array);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMessageExample(AsyncApi30MessageExample node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setAnyMapProperty(json, "headers", node.getHeaders());
        JsonUtil.setAnyMapProperty(json, "payload", node.getPayload());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeTag(AsyncApi30Tag node, ObjectNode json) {
        Map<String, JsonNode> values;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        if (node.getExternalDocs() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi30ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeExternalDocumentation(AsyncApi30ExternalDocumentation node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeReference(AsyncApi30Reference node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeComponents(AsyncApi30Components node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        Map<String, Node> models = node.getSchemas();
        if (models != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi30Schema)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "schemas", object);
        }
        if ((models = node.getServers()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeServer((AsyncApi30Server)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "servers", object);
        }
        if ((models = node.getChannels()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeChannel((AsyncApi30Channel)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "channels", object);
        }
        if ((models = node.getOperations()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeOperation((AsyncApi30Operation)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "operations", object);
        }
        if ((models = node.getMessages()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMessage((AsyncApi30Message)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "messages", object);
        }
        if ((models = node.getSecuritySchemes()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSecurityScheme((AsyncApi30SecurityScheme)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "securitySchemes", object);
        }
        if ((models = node.getServerVariables()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeServerVariable((AsyncApi30ServerVariable)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "serverVariables", object);
        }
        if ((models = node.getParameters()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeParameter((AsyncApi30Parameter)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "parameters", object);
        }
        if ((models = node.getCorrelationIds()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeCorrelationID((AsyncApi30CorrelationID)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "correlationIds", object);
        }
        if ((models = node.getReplies()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeOperationReply((AsyncApi30OperationReply)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "replies", object);
        }
        if ((models = node.getReplyAddresses()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeOperationReplyAddress((AsyncApi30OperationReplyAddress)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "replyAddresses", object);
        }
        if ((models = node.getExternalDocs()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeExternalDocumentation((AsyncApi30ExternalDocumentation)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if ((models = node.getTags()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeTag((AsyncApi30Tag)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "tags", object);
        }
        if ((models = node.getOperationTraits()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeOperationTrait((AsyncApi30OperationTrait)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "operationTraits", object);
        }
        if ((models = node.getMessageTraits()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMessageTrait((AsyncApi30MessageTrait)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "messageTraits", object);
        }
        if ((models = node.getServerBindings()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeServerBindings((AsyncApi30ServerBindings)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "serverBindings", object);
        }
        if ((models = node.getChannelBindings()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeChannelBindings((AsyncApi30ChannelBindings)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "channelBindings", object);
        }
        if ((models = node.getOperationBindings()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeOperationBindings((AsyncApi30OperationBindings)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "operationBindings", object);
        }
        if ((models = node.getMessageBindings()) != null && !models.isEmpty()) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMessageBindings((AsyncApi30MessageBindings)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "messageBindings", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMultiFormatSchema(AsyncApi30MultiFormatSchema node, ObjectNode json) {
        Map<String, JsonNode> values;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "schemaFormat", node.getSchemaFormat());
        AnySchemaUnion union = node.getSchema();
        if (union != null) {
            if (union.isAny()) {
                JsonUtil.setAnyProperty(json, "schema", union.asAny());
            }
            if (union.isSchema()) {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi30Schema)union.asSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "schema", jsonValue);
            }
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeSchema(AsyncApi30Schema node, ObjectNode json) {
        ArrayNode array;
        ObjectNode jsonValue;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "type", node.getType());
        JsonUtil.setStringArrayProperty(json, "required", node.getRequired());
        JsonUtil.setNumberProperty(json, "multipleOf", node.getMultipleOf());
        JsonUtil.setNumberProperty(json, "maximum", node.getMaximum());
        JsonUtil.setNumberProperty(json, "exclusiveMaximum", node.getExclusiveMaximum());
        JsonUtil.setNumberProperty(json, "minimum", node.getMinimum());
        JsonUtil.setNumberProperty(json, "exclusiveMinimum", node.getExclusiveMinimum());
        JsonUtil.setIntegerProperty(json, "maxLength", node.getMaxLength());
        JsonUtil.setIntegerProperty(json, "minLength", node.getMinLength());
        JsonUtil.setStringProperty(json, "pattern", node.getPattern());
        JsonUtil.setIntegerProperty(json, "maxItems", node.getMaxItems());
        JsonUtil.setIntegerProperty(json, "minItems", node.getMinItems());
        JsonUtil.setBooleanProperty(json, "uniqueItems", node.isUniqueItems());
        JsonUtil.setIntegerProperty(json, "maxProperties", node.getMaxProperties());
        JsonUtil.setIntegerProperty(json, "minProperties", node.getMinProperties());
        JsonUtil.setAnyArrayProperty(json, "enum", node.getEnum());
        JsonUtil.setAnyProperty(json, "const", node.getConst());
        JsonUtil.setAnyArrayProperty(json, "examples", node.getExamples());
        if (node.getIf() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi30Schema)node.getIf(), object);
            JsonUtil.setObjectProperty(json, "if", object);
        }
        if (node.getThen() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi30Schema)node.getThen(), object);
            JsonUtil.setObjectProperty(json, "then", object);
        }
        if (node.getElse() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi30Schema)node.getElse(), object);
            JsonUtil.setObjectProperty(json, "else", object);
        }
        JsonUtil.setBooleanProperty(json, "readOnly", node.isReadOnly());
        JsonUtil.setBooleanProperty(json, "writeOnly", node.isWriteOnly());
        List<AsyncApiSchema> models = node.getProperties();
        if (models != null && !models.isEmpty()) {
            ObjectNode object2 = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi30Schema)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object2, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "properties", object2);
        }
        JsonUtil.setStringMapProperty(json, "patternProperties", node.getPatternProperties());
        Union union = node.getAdditionalProperties();
        if (union != null) {
            if (union.isBoolean()) {
                JsonUtil.setBooleanProperty(json, "additionalProperties", union.asBoolean());
            }
            if (union.isSchema()) {
                jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi30Schema)union.asSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "additionalProperties", jsonValue);
            }
        }
        if (node.getAdditionalItems() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi30Schema)node.getAdditionalItems(), object);
            JsonUtil.setObjectProperty(json, "additionalItems", object);
        }
        if ((union = node.getItems()) != null) {
            if (union.isSchema()) {
                jsonValue = JsonUtil.objectNode();
                this.writeSchema((AsyncApi30Schema)union.asSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "items", jsonValue);
            }
            if (union.isSchemaList()) {
                List<Schema> models2 = union.asSchemaList();
                ArrayNode array2 = JsonUtil.arrayNode();
                models2.forEach(model -> {
                    ObjectNode object = JsonUtil.objectNode();
                    this.writeSchema((AsyncApi30Schema)model, object);
                    JsonUtil.addToArray(array2, (JsonNode)object);
                });
                JsonUtil.setAnyProperty(json, "items", (JsonNode)array2);
            }
        }
        if (node.getPropertyNames() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi30Schema)node.getPropertyNames(), object);
            JsonUtil.setObjectProperty(json, "propertyNames", object);
        }
        if (node.getContains() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi30Schema)node.getContains(), object);
            JsonUtil.setObjectProperty(json, "contains", object);
        }
        if ((models = node.getAllOf()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSchema((AsyncApi30Schema)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "allOf", (JsonNode)array);
        }
        if ((models = node.getOneOf()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSchema((AsyncApi30Schema)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "oneOf", (JsonNode)array);
        }
        if ((models = node.getAnyOf()) != null && !models.isEmpty()) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSchema((AsyncApi30Schema)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "anyOf", (JsonNode)array);
        }
        if (node.getNot() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema((AsyncApi30Schema)node.getNot(), object);
            JsonUtil.setObjectProperty(json, "not", object);
        }
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "format", node.getFormat());
        JsonUtil.setAnyProperty(json, "default", node.getDefault());
        JsonUtil.setStringProperty(json, "discriminator", node.getDiscriminator());
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((AsyncApi30ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        JsonUtil.setBooleanProperty(json, "deprecated", node.isDeprecated());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeSecurityScheme(AsyncApi30SecurityScheme node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "type", node.getType());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "in", node.getIn());
        JsonUtil.setStringProperty(json, "scheme", node.getScheme());
        JsonUtil.setStringProperty(json, "bearerFormat", node.getBearerFormat());
        if (node.getFlows() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeOAuthFlows((AsyncApi30OAuthFlows)node.getFlows(), object);
            JsonUtil.setObjectProperty(json, "flows", object);
        }
        JsonUtil.setStringProperty(json, "openIdConnectUrl", node.getOpenIdConnectUrl());
        JsonUtil.setStringArrayProperty(json, "scopes", node.getScopes());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOAuthFlows(AsyncApi30OAuthFlows node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        if (node.getImplicit() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((AsyncApi30OAuthFlow)node.getImplicit(), object);
            JsonUtil.setObjectProperty(json, "implicit", object);
        }
        if (node.getPassword() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((AsyncApi30OAuthFlow)node.getPassword(), object);
            JsonUtil.setObjectProperty(json, "password", object);
        }
        if (node.getClientCredentials() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((AsyncApi30OAuthFlow)node.getClientCredentials(), object);
            JsonUtil.setObjectProperty(json, "clientCredentials", object);
        }
        if (node.getAuthorizationCode() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((AsyncApi30OAuthFlow)node.getAuthorizationCode(), object);
            JsonUtil.setObjectProperty(json, "authorizationCode", object);
        }
        if ((values = node.getExtensions()) != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOAuthFlow(AsyncApi30OAuthFlow node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "authorizationUrl", node.getAuthorizationUrl());
        JsonUtil.setStringProperty(json, "tokenUrl", node.getTokenUrl());
        JsonUtil.setStringProperty(json, "refreshUrl", node.getRefreshUrl());
        JsonUtil.setStringMapProperty(json, "availableScopes", node.getAvailableScopes());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeCorrelationID(AsyncApi30CorrelationID node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "location", node.getLocation());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeBinding(AsyncApi30Binding node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            JsonNode value = (JsonNode)node.getItem((String)propertyName);
            JsonUtil.setAnyProperty(json, propertyName, value);
        });
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null && !values.isEmpty()) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }
}

