/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.io;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.asyncapi.v20.io.AsyncApi20ModelWriter;
import io.apicurio.datamodels.models.asyncapi.v20.io.AsyncApi20ModelWriterDispatcher;
import io.apicurio.datamodels.models.asyncapi.v21.io.AsyncApi21ModelWriter;
import io.apicurio.datamodels.models.asyncapi.v21.io.AsyncApi21ModelWriterDispatcher;
import io.apicurio.datamodels.models.asyncapi.v22.io.AsyncApi22ModelWriter;
import io.apicurio.datamodels.models.asyncapi.v22.io.AsyncApi22ModelWriterDispatcher;
import io.apicurio.datamodels.models.asyncapi.v23.io.AsyncApi23ModelWriter;
import io.apicurio.datamodels.models.asyncapi.v23.io.AsyncApi23ModelWriterDispatcher;
import io.apicurio.datamodels.models.asyncapi.v24.io.AsyncApi24ModelWriter;
import io.apicurio.datamodels.models.asyncapi.v24.io.AsyncApi24ModelWriterDispatcher;
import io.apicurio.datamodels.models.asyncapi.v25.io.AsyncApi25ModelWriter;
import io.apicurio.datamodels.models.asyncapi.v25.io.AsyncApi25ModelWriterDispatcher;
import io.apicurio.datamodels.models.asyncapi.v26.io.AsyncApi26ModelWriter;
import io.apicurio.datamodels.models.asyncapi.v26.io.AsyncApi26ModelWriterDispatcher;
import io.apicurio.datamodels.models.asyncapi.v30.io.AsyncApi30ModelWriter;
import io.apicurio.datamodels.models.asyncapi.v30.io.AsyncApi30ModelWriterDispatcher;
import io.apicurio.datamodels.models.io.ModelWriter;
import io.apicurio.datamodels.models.openapi.v20.io.OpenApi20ModelWriter;
import io.apicurio.datamodels.models.openapi.v20.io.OpenApi20ModelWriterDispatcher;
import io.apicurio.datamodels.models.openapi.v30.io.OpenApi30ModelWriter;
import io.apicurio.datamodels.models.openapi.v30.io.OpenApi30ModelWriterDispatcher;
import io.apicurio.datamodels.models.openapi.v31.io.OpenApi31ModelWriter;
import io.apicurio.datamodels.models.openapi.v31.io.OpenApi31ModelWriterDispatcher;
import io.apicurio.datamodels.models.visitors.Visitor;

public class ModelWriterFactory {
    public static ModelWriter createModelWriter(ModelType modelType) {
        ModelWriter writer = null;
        switch (modelType) {
            case ASYNCAPI21: {
                writer = new AsyncApi21ModelWriter();
                break;
            }
            case ASYNCAPI20: {
                writer = new AsyncApi20ModelWriter();
                break;
            }
            case OPENAPI30: {
                writer = new OpenApi30ModelWriter();
                break;
            }
            case OPENAPI31: {
                writer = new OpenApi31ModelWriter();
                break;
            }
            case ASYNCAPI26: {
                writer = new AsyncApi26ModelWriter();
                break;
            }
            case OPENAPI20: {
                writer = new OpenApi20ModelWriter();
                break;
            }
            case ASYNCAPI30: {
                writer = new AsyncApi30ModelWriter();
                break;
            }
            case ASYNCAPI23: {
                writer = new AsyncApi23ModelWriter();
                break;
            }
            case ASYNCAPI24: {
                writer = new AsyncApi24ModelWriter();
                break;
            }
            case ASYNCAPI25: {
                writer = new AsyncApi25ModelWriter();
                break;
            }
            case ASYNCAPI22: {
                writer = new AsyncApi22ModelWriter();
            }
        }
        return writer;
    }

    public static Visitor createModelWriterDispatcher(ModelType modelType, ObjectNode json) {
        ModelWriter writer = ModelWriterFactory.createModelWriter(modelType);
        Visitor visitor = null;
        switch (modelType) {
            case ASYNCAPI21: {
                visitor = new AsyncApi21ModelWriterDispatcher(json, (AsyncApi21ModelWriter)writer);
                break;
            }
            case ASYNCAPI20: {
                visitor = new AsyncApi20ModelWriterDispatcher(json, (AsyncApi20ModelWriter)writer);
                break;
            }
            case OPENAPI30: {
                visitor = new OpenApi30ModelWriterDispatcher(json, (OpenApi30ModelWriter)writer);
                break;
            }
            case OPENAPI31: {
                visitor = new OpenApi31ModelWriterDispatcher(json, (OpenApi31ModelWriter)writer);
                break;
            }
            case ASYNCAPI26: {
                visitor = new AsyncApi26ModelWriterDispatcher(json, (AsyncApi26ModelWriter)writer);
                break;
            }
            case OPENAPI20: {
                visitor = new OpenApi20ModelWriterDispatcher(json, (OpenApi20ModelWriter)writer);
                break;
            }
            case ASYNCAPI30: {
                visitor = new AsyncApi30ModelWriterDispatcher(json, (AsyncApi30ModelWriter)writer);
                break;
            }
            case ASYNCAPI23: {
                visitor = new AsyncApi23ModelWriterDispatcher(json, (AsyncApi23ModelWriter)writer);
                break;
            }
            case ASYNCAPI24: {
                visitor = new AsyncApi24ModelWriterDispatcher(json, (AsyncApi24ModelWriter)writer);
                break;
            }
            case ASYNCAPI25: {
                visitor = new AsyncApi25ModelWriterDispatcher(json, (AsyncApi25ModelWriter)writer);
                break;
            }
            case ASYNCAPI22: {
                visitor = new AsyncApi22ModelWriterDispatcher(json, (AsyncApi22ModelWriter)writer);
            }
        }
        return visitor;
    }
}

