/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.openapi.v20.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.RootNode;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.io.ModelReader;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Contact;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Definitions;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Document;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20DocumentImpl;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Example;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20ExternalDocumentation;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Header;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Info;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Items;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20License;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Operation;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Parameter;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20ParameterDefinitions;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20PathItem;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Paths;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Response;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20ResponseDefinitions;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Responses;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Schema;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Scopes;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20SecurityDefinitions;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20SecurityRequirement;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20SecurityScheme;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Tag;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20XML;
import io.apicurio.datamodels.models.union.BooleanUnionValueImpl;
import io.apicurio.datamodels.models.union.SchemaListUnionValueImpl;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.apicurio.datamodels.models.util.ReaderUtil;
import java.util.ArrayList;
import java.util.List;

public class OpenApi20ModelReader
implements ModelReader {
    public void readDocument(ObjectNode json, OpenApi20Document node) {
        List<ObjectNode> objects;
        List<String> value = JsonUtil.consumeStringProperty(json, "swagger");
        node.setSwagger((String)((Object)value));
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "info");
        if (object2 != null) {
            node.setInfo(node.createInfo());
            this.readInfo(object2, (OpenApi20Info)node.getInfo());
        }
        value = JsonUtil.consumeStringProperty(json, "host");
        node.setHost((String)((Object)value));
        value = JsonUtil.consumeStringProperty(json, "basePath");
        node.setBasePath((String)((Object)value));
        value = JsonUtil.consumeStringArrayProperty(json, "schemes");
        node.setSchemes(value);
        value = JsonUtil.consumeStringArrayProperty(json, "consumes");
        node.setConsumes(value);
        value = JsonUtil.consumeStringArrayProperty(json, "produces");
        node.setProduces(value);
        object2 = JsonUtil.consumeObjectProperty(json, "paths");
        if (object2 != null) {
            node.setPaths(node.createPaths());
            this.readPaths(object2, (OpenApi20Paths)node.getPaths());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "definitions")) != null) {
            node.setDefinitions(node.createDefinitions());
            this.readDefinitions(object2, node.getDefinitions());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "parameters")) != null) {
            node.setParameters(node.createParameterDefinitions());
            this.readParameterDefinitions(object2, node.getParameters());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "responses")) != null) {
            node.setResponses(node.createResponseDefinitions());
            this.readResponseDefinitions(object2, node.getResponses());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "securityDefinitions")) != null) {
            node.setSecurityDefinitions(node.createSecurityDefinitions());
            this.readSecurityDefinitions(object2, node.getSecurityDefinitions());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "security")) != null) {
            objects.forEach(object -> {
                OpenApi20SecurityRequirement model = node.createSecurityRequirement();
                this.readSecurityRequirement((ObjectNode)object, model);
                node.addSecurity(model);
            });
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "tags")) != null) {
            objects.forEach(object -> {
                OpenApi20Tag model = (OpenApi20Tag)node.createTag();
                this.readTag((ObjectNode)object, model);
                node.addTag(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "externalDocs")) != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, (OpenApi20ExternalDocumentation)node.getExternalDocs());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    @Override
    public RootNode readRoot(ObjectNode json) {
        OpenApi20DocumentImpl rootModel = new OpenApi20DocumentImpl();
        this.readDocument(json, rootModel);
        return rootModel;
    }

    public void readInfo(ObjectNode json, OpenApi20Info node) {
        String value = JsonUtil.consumeStringProperty(json, "title");
        node.setTitle(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "termsOfService");
        node.setTermsOfService(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "contact");
        if (object != null) {
            node.setContact(node.createContact());
            this.readContact(object, (OpenApi20Contact)node.getContact());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "license")) != null) {
            node.setLicense(node.createLicense());
            this.readLicense(object, (OpenApi20License)node.getLicense());
        }
        value = JsonUtil.consumeStringProperty(json, "version");
        node.setVersion(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readContact(ObjectNode json, OpenApi20Contact node) {
        String value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        value = JsonUtil.consumeStringProperty(json, "email");
        node.setEmail(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readLicense(ObjectNode json, OpenApi20License node) {
        String value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readPaths(ObjectNode json, OpenApi20Paths node) {
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                OpenApi20PathItem model = (OpenApi20PathItem)node.createPathItem();
                this.readPathItem(object, model);
                node.addItem((String)name, model);
            }
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readPathItem(ObjectNode json, OpenApi20PathItem node) {
        List<ObjectNode> objects;
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "get");
        if (object2 != null) {
            node.setGet(node.createOperation());
            this.readOperation(object2, (OpenApi20Operation)node.getGet());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "put")) != null) {
            node.setPut(node.createOperation());
            this.readOperation(object2, (OpenApi20Operation)node.getPut());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "post")) != null) {
            node.setPost(node.createOperation());
            this.readOperation(object2, (OpenApi20Operation)node.getPost());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "delete")) != null) {
            node.setDelete(node.createOperation());
            this.readOperation(object2, (OpenApi20Operation)node.getDelete());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "options")) != null) {
            node.setOptions(node.createOperation());
            this.readOperation(object2, (OpenApi20Operation)node.getOptions());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "head")) != null) {
            node.setHead(node.createOperation());
            this.readOperation(object2, (OpenApi20Operation)node.getHead());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "patch")) != null) {
            node.setPatch(node.createOperation());
            this.readOperation(object2, (OpenApi20Operation)node.getPatch());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "parameters")) != null) {
            objects.forEach(object -> {
                OpenApi20Parameter model = node.createParameter();
                this.readParameter((ObjectNode)object, model);
                node.addParameter(model);
            });
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOperation(ObjectNode json, OpenApi20Operation node) {
        Object value = JsonUtil.consumeStringArrayProperty(json, "tags");
        node.setTags((List<String>)value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "externalDocs");
        if (object2 != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, (OpenApi20ExternalDocumentation)node.getExternalDocs());
        }
        value = JsonUtil.consumeStringProperty(json, "operationId");
        node.setOperationId((String)value);
        value = JsonUtil.consumeStringArrayProperty(json, "consumes");
        node.setConsumes((List<String>)value);
        value = JsonUtil.consumeStringArrayProperty(json, "produces");
        node.setProduces((List<String>)value);
        List<ObjectNode> objects = JsonUtil.consumeObjectArrayProperty(json, "parameters");
        if (objects != null) {
            objects.forEach(object -> {
                OpenApi20Parameter model = node.createParameter();
                this.readParameter((ObjectNode)object, model);
                node.addParameter(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "responses")) != null) {
            node.setResponses(node.createResponses());
            this.readResponses(object2, (OpenApi20Responses)node.getResponses());
        }
        value = JsonUtil.consumeStringArrayProperty(json, "schemes");
        node.setSchemes((List<String>)value);
        value = JsonUtil.consumeBooleanProperty(json, "deprecated");
        node.setDeprecated((Boolean)value);
        objects = JsonUtil.consumeObjectArrayProperty(json, "security");
        if (objects != null) {
            objects.forEach(object -> {
                OpenApi20SecurityRequirement model = node.createSecurityRequirement();
                this.readSecurityRequirement((ObjectNode)object, model);
                node.addSecurity(model);
            });
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readExternalDocumentation(ObjectNode json, OpenApi20ExternalDocumentation node) {
        String value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readParameter(ObjectNode json, OpenApi20Parameter node) {
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        value = JsonUtil.consumeStringProperty(json, "type");
        node.setType((String)value);
        value = JsonUtil.consumeStringProperty(json, "format");
        node.setFormat((String)value);
        value = JsonUtil.consumeAnyProperty(json, "default");
        node.setDefault((JsonNode)value);
        value = JsonUtil.consumeNumberProperty(json, "maximum");
        node.setMaximum((Number)value);
        value = JsonUtil.consumeBooleanProperty(json, "exclusiveMaximum");
        node.setExclusiveMaximum((Boolean)value);
        value = JsonUtil.consumeNumberProperty(json, "minimum");
        node.setMinimum((Number)value);
        value = JsonUtil.consumeBooleanProperty(json, "exclusiveMinimum");
        node.setExclusiveMinimum((Boolean)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxLength");
        node.setMaxLength((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minLength");
        node.setMinLength((Integer)value);
        value = JsonUtil.consumeStringProperty(json, "pattern");
        node.setPattern((String)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxItems");
        node.setMaxItems((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minItems");
        node.setMinItems((Integer)value);
        value = JsonUtil.consumeBooleanProperty(json, "uniqueItems");
        node.setUniqueItems((Boolean)value);
        value = JsonUtil.consumeAnyArrayProperty(json, "enum");
        node.setEnum((List<JsonNode>)value);
        value = JsonUtil.consumeNumberProperty(json, "multipleOf");
        node.setMultipleOf((Number)value);
        value = JsonUtil.consumeStringProperty(json, "name");
        node.setName((String)value);
        value = JsonUtil.consumeStringProperty(json, "in");
        node.setIn((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "required");
        node.setRequired((Boolean)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "schema");
        if (object != null) {
            node.setSchema(node.createSchema());
            this.readSchema(object, (OpenApi20Schema)node.getSchema());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "items")) != null) {
            node.setItems(node.createItems());
            this.readItems(object, node.getItems());
        }
        value = JsonUtil.consumeBooleanProperty(json, "allowEmptyValue");
        node.setAllowEmptyValue((Boolean)value);
        value = JsonUtil.consumeStringProperty(json, "collectionFormat");
        node.setCollectionFormat((String)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readItems(ObjectNode json, OpenApi20Items node) {
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        value = JsonUtil.consumeStringProperty(json, "type");
        node.setType((String)value);
        value = JsonUtil.consumeStringProperty(json, "format");
        node.setFormat((String)value);
        value = JsonUtil.consumeAnyProperty(json, "default");
        node.setDefault((JsonNode)value);
        value = JsonUtil.consumeNumberProperty(json, "maximum");
        node.setMaximum((Number)value);
        value = JsonUtil.consumeBooleanProperty(json, "exclusiveMaximum");
        node.setExclusiveMaximum((Boolean)value);
        value = JsonUtil.consumeNumberProperty(json, "minimum");
        node.setMinimum((Number)value);
        value = JsonUtil.consumeBooleanProperty(json, "exclusiveMinimum");
        node.setExclusiveMinimum((Boolean)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxLength");
        node.setMaxLength((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minLength");
        node.setMinLength((Integer)value);
        value = JsonUtil.consumeStringProperty(json, "pattern");
        node.setPattern((String)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxItems");
        node.setMaxItems((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minItems");
        node.setMinItems((Integer)value);
        value = JsonUtil.consumeBooleanProperty(json, "uniqueItems");
        node.setUniqueItems((Boolean)value);
        value = JsonUtil.consumeAnyArrayProperty(json, "enum");
        node.setEnum((List<JsonNode>)value);
        value = JsonUtil.consumeNumberProperty(json, "multipleOf");
        node.setMultipleOf((Number)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "items");
        if (object != null) {
            node.setItems(node.createItems());
            this.readItems(object, node.getItems());
        }
        value = JsonUtil.consumeStringProperty(json, "collectionFormat");
        node.setCollectionFormat((String)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readResponses(ObjectNode json, OpenApi20Responses node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "default");
        if (object != null) {
            node.setDefault(node.createResponse());
            this.readResponse(object, (OpenApi20Response)node.getDefault());
        }
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                OpenApi20Response model = (OpenApi20Response)node.createResponse();
                this.readResponse(object, model);
                node.addItem((String)name, model);
            }
        });
        propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readResponse(ObjectNode json, OpenApi20Response node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "schema");
        if (object != null) {
            node.setSchema(node.createSchema());
            this.readSchema(object, node.getSchema());
        }
        object = JsonUtil.consumeObjectProperty(json, "headers");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi20Header model = node.createHeader();
                this.readHeader(mapValue, model);
                node.addHeader((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "examples");
        if (object != null) {
            node.setExamples(node.createExample());
            this.readExample(object, node.getExamples());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readExample(ObjectNode json, OpenApi20Example node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addItem((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readHeader(ObjectNode json, OpenApi20Header node) {
        Object value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        value = JsonUtil.consumeStringProperty(json, "type");
        node.setType((String)value);
        value = JsonUtil.consumeStringProperty(json, "format");
        node.setFormat((String)value);
        value = JsonUtil.consumeAnyProperty(json, "default");
        node.setDefault((JsonNode)value);
        value = JsonUtil.consumeNumberProperty(json, "maximum");
        node.setMaximum((Number)value);
        value = JsonUtil.consumeBooleanProperty(json, "exclusiveMaximum");
        node.setExclusiveMaximum((Boolean)value);
        value = JsonUtil.consumeNumberProperty(json, "minimum");
        node.setMinimum((Number)value);
        value = JsonUtil.consumeBooleanProperty(json, "exclusiveMinimum");
        node.setExclusiveMinimum((Boolean)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxLength");
        node.setMaxLength((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minLength");
        node.setMinLength((Integer)value);
        value = JsonUtil.consumeStringProperty(json, "pattern");
        node.setPattern((String)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxItems");
        node.setMaxItems((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minItems");
        node.setMinItems((Integer)value);
        value = JsonUtil.consumeBooleanProperty(json, "uniqueItems");
        node.setUniqueItems((Boolean)value);
        value = JsonUtil.consumeAnyArrayProperty(json, "enum");
        node.setEnum((List<JsonNode>)value);
        value = JsonUtil.consumeNumberProperty(json, "multipleOf");
        node.setMultipleOf((Number)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "items");
        if (object != null) {
            node.setItems(node.createItems());
            this.readItems(object, node.getItems());
        }
        value = JsonUtil.consumeStringProperty(json, "collectionFormat");
        node.setCollectionFormat((String)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readTag(ObjectNode json, OpenApi20Tag node) {
        String value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "externalDocs");
        if (object != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object, (OpenApi20ExternalDocumentation)node.getExternalDocs());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSchema(ObjectNode json, OpenApi20Schema node) {
        ObjectNode object2;
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        value = JsonUtil.consumeStringProperty(json, "type");
        node.setType((String)value);
        value = JsonUtil.consumeStringProperty(json, "format");
        node.setFormat((String)value);
        value = JsonUtil.consumeAnyProperty(json, "default");
        node.setDefault((JsonNode)value);
        value = JsonUtil.consumeNumberProperty(json, "maximum");
        node.setMaximum((Number)value);
        value = JsonUtil.consumeBooleanProperty(json, "exclusiveMaximum");
        node.setExclusiveMaximum((Boolean)value);
        value = JsonUtil.consumeNumberProperty(json, "minimum");
        node.setMinimum((Number)value);
        value = JsonUtil.consumeBooleanProperty(json, "exclusiveMinimum");
        node.setExclusiveMinimum((Boolean)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxLength");
        node.setMaxLength((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minLength");
        node.setMinLength((Integer)value);
        value = JsonUtil.consumeStringProperty(json, "pattern");
        node.setPattern((String)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxItems");
        node.setMaxItems((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minItems");
        node.setMinItems((Integer)value);
        value = JsonUtil.consumeBooleanProperty(json, "uniqueItems");
        node.setUniqueItems((Boolean)value);
        value = JsonUtil.consumeAnyArrayProperty(json, "enum");
        node.setEnum((List<JsonNode>)value);
        value = JsonUtil.consumeNumberProperty(json, "multipleOf");
        node.setMultipleOf((Number)value);
        value = JsonUtil.consumeStringProperty(json, "title");
        node.setTitle((String)value);
        value = JsonUtil.consumeAnyProperty(json, "items");
        if (value != null) {
            if (JsonUtil.isObject(value)) {
                object2 = JsonUtil.toObject(value);
                node.setItems(node.createSchema());
                this.readSchema(object2, (OpenApi20Schema)node.getItems());
            } else if (JsonUtil.isArray(value)) {
                List<JsonNode> array = JsonUtil.toList(value);
                ArrayList<Schema> models = new ArrayList<Schema>();
                array.forEach(item -> {
                    ObjectNode object = JsonUtil.toObject(item);
                    OpenApi20Schema model = node.createSchema();
                    this.readSchema(object, model);
                    models.add(model);
                });
                SchemaListUnionValueImpl unionValue = new SchemaListUnionValueImpl((List<Schema>)models);
                node.setItems(unionValue);
            } else {
                node.addExtraProperty("items", (JsonNode)value);
            }
        }
        value = JsonUtil.consumeIntegerProperty(json, "maxProperties");
        node.setMaxProperties((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minProperties");
        node.setMinProperties((Integer)value);
        value = JsonUtil.consumeStringArrayProperty(json, "required");
        node.setRequired((List<String>)value);
        List<ObjectNode> objects = JsonUtil.consumeObjectArrayProperty(json, "allOf");
        if (objects != null) {
            objects.forEach(object -> {
                OpenApi20Schema model = node.createSchema();
                this.readSchema((ObjectNode)object, model);
                node.addAllOf(model);
            });
        }
        ObjectNode object3 = JsonUtil.consumeObjectProperty(json, "properties");
        JsonUtil.keys(object3).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object3, name);
            if (mapValue != null) {
                OpenApi20Schema model = node.createSchema();
                this.readSchema(mapValue, model);
                node.addProperty((String)name, model);
            }
        });
        value = JsonUtil.consumeAnyProperty(json, "additionalProperties");
        if (value != null) {
            if (JsonUtil.isObject(value)) {
                object2 = JsonUtil.toObject(value);
                node.setAdditionalProperties(node.createSchema());
                this.readSchema(object2, (OpenApi20Schema)node.getAdditionalProperties());
            } else if (JsonUtil.isBoolean(value)) {
                Boolean pValue = JsonUtil.toBoolean(value);
                BooleanUnionValueImpl unionValue = new BooleanUnionValueImpl(pValue);
                node.setAdditionalProperties(unionValue);
            } else {
                node.addExtraProperty("additionalProperties", (JsonNode)value);
            }
        }
        value = JsonUtil.consumeStringProperty(json, "discriminator");
        node.setDiscriminator((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "readOnly");
        node.setReadOnly((Boolean)value);
        object3 = JsonUtil.consumeObjectProperty(json, "xml");
        if (object3 != null) {
            node.setXml(node.createXML());
            this.readXML(object3, (OpenApi20XML)node.getXml());
        }
        if ((object3 = JsonUtil.consumeObjectProperty(json, "externalDocs")) != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object3, (OpenApi20ExternalDocumentation)node.getExternalDocs());
        }
        value = JsonUtil.consumeAnyProperty(json, "example");
        node.setExample((JsonNode)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readXML(ObjectNode json, OpenApi20XML node) {
        Object value = JsonUtil.consumeStringProperty(json, "name");
        node.setName((String)value);
        value = JsonUtil.consumeStringProperty(json, "namespace");
        node.setNamespace((String)value);
        value = JsonUtil.consumeStringProperty(json, "prefix");
        node.setPrefix((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "attribute");
        node.setAttribute((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "wrapped");
        node.setWrapped((Boolean)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readDefinitions(ObjectNode json, OpenApi20Definitions node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                OpenApi20Schema model = node.createSchema();
                this.readSchema(object, model);
                node.addItem((String)name, model);
            }
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readParameterDefinitions(ObjectNode json, OpenApi20ParameterDefinitions node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                OpenApi20Parameter model = node.createParameter();
                this.readParameter(object, model);
                node.addItem((String)name, model);
            }
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readResponseDefinitions(ObjectNode json, OpenApi20ResponseDefinitions node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                OpenApi20Response model = node.createResponse();
                this.readResponse(object, model);
                node.addItem((String)name, model);
            }
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSecurityDefinitions(ObjectNode json, OpenApi20SecurityDefinitions node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                OpenApi20SecurityScheme model = node.createSecurityScheme();
                this.readSecurityScheme(object, model);
                node.addItem((String)name, model);
            }
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSecurityScheme(ObjectNode json, OpenApi20SecurityScheme node) {
        String value = JsonUtil.consumeStringProperty(json, "type");
        node.setType(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "in");
        node.setIn(value);
        value = JsonUtil.consumeStringProperty(json, "flow");
        node.setFlow(value);
        value = JsonUtil.consumeStringProperty(json, "authorizationUrl");
        node.setAuthorizationUrl(value);
        value = JsonUtil.consumeStringProperty(json, "tokenUrl");
        node.setTokenUrl(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "scopes");
        if (object != null) {
            node.setScopes(node.createScopes());
            this.readScopes(object, node.getScopes());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readScopes(ObjectNode json, OpenApi20Scopes node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            String value = JsonUtil.consumeStringProperty(json, name);
            node.addItem((String)name, value);
        });
        propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSecurityRequirement(ObjectNode json, OpenApi20SecurityRequirement node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            List<String> value = JsonUtil.consumeStringArrayProperty(json, name);
            node.addItem((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }
}

