/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.openapi.v31.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.RootNode;
import io.apicurio.datamodels.models.io.ModelReader;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Callback;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Components;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Contact;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Discriminator;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Document;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31DocumentImpl;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Encoding;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Example;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31ExternalDocumentation;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Header;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Info;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31License;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Link;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31MediaType;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31OAuthFlow;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31OAuthFlows;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Operation;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Parameter;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31PathItem;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Paths;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31RequestBody;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Response;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Responses;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Schema;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31SecurityRequirement;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31SecurityScheme;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Server;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31ServerVariable;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Tag;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31XML;
import io.apicurio.datamodels.models.union.BooleanSchemaUnion;
import io.apicurio.datamodels.models.union.BooleanUnionValueImpl;
import io.apicurio.datamodels.models.union.PrimitiveUnionValueImpl;
import io.apicurio.datamodels.models.union.StringListUnionValueImpl;
import io.apicurio.datamodels.models.union.StringStringListUnion;
import io.apicurio.datamodels.models.union.StringUnionValueImpl;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.apicurio.datamodels.models.util.ReaderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OpenApi31ModelReader
implements ModelReader {
    public void readDocument(ObjectNode json, OpenApi31Document node) {
        List<ObjectNode> objects;
        String value = JsonUtil.consumeStringProperty(json, "openapi");
        node.setOpenapi(value);
        value = JsonUtil.consumeStringProperty(json, "jsonSchemaDialect");
        node.setJsonSchemaDialect(value);
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "info");
        if (object2 != null) {
            node.setInfo(node.createInfo());
            this.readInfo(object2, (OpenApi31Info)node.getInfo());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "servers")) != null) {
            objects.forEach(object -> {
                OpenApi31Server model = node.createServer();
                this.readServer((ObjectNode)object, model);
                node.addServer(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "paths")) != null) {
            node.setPaths(node.createPaths());
            this.readPaths(object2, (OpenApi31Paths)node.getPaths());
        }
        object2 = JsonUtil.consumeObjectProperty(json, "webhooks");
        JsonUtil.keys(object2).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object2, name);
            if (mapValue != null) {
                OpenApi31PathItem model = node.createPathItem();
                this.readPathItem(mapValue, model);
                node.addWebhook((String)name, model);
            }
        });
        object2 = JsonUtil.consumeObjectProperty(json, "components");
        if (object2 != null) {
            node.setComponents(node.createComponents());
            this.readComponents(object2, node.getComponents());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "security")) != null) {
            objects.forEach(object -> {
                OpenApi31SecurityRequirement model = node.createSecurityRequirement();
                this.readSecurityRequirement((ObjectNode)object, model);
                node.addSecurity(model);
            });
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "tags")) != null) {
            objects.forEach(object -> {
                OpenApi31Tag model = (OpenApi31Tag)node.createTag();
                this.readTag((ObjectNode)object, model);
                node.addTag(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "externalDocs")) != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, (OpenApi31ExternalDocumentation)node.getExternalDocs());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    @Override
    public RootNode readRoot(ObjectNode json) {
        OpenApi31DocumentImpl rootModel = new OpenApi31DocumentImpl();
        this.readDocument(json, rootModel);
        return rootModel;
    }

    public void readInfo(ObjectNode json, OpenApi31Info node) {
        String value = JsonUtil.consumeStringProperty(json, "title");
        node.setTitle(value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "termsOfService");
        node.setTermsOfService(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "contact");
        if (object != null) {
            node.setContact(node.createContact());
            this.readContact(object, (OpenApi31Contact)node.getContact());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "license")) != null) {
            node.setLicense(node.createLicense());
            this.readLicense(object, (OpenApi31License)node.getLicense());
        }
        value = JsonUtil.consumeStringProperty(json, "version");
        node.setVersion(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readContact(ObjectNode json, OpenApi31Contact node) {
        String value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        value = JsonUtil.consumeStringProperty(json, "email");
        node.setEmail(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readLicense(ObjectNode json, OpenApi31License node) {
        String value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "identifier");
        node.setIdentifier(value);
        value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readServer(ObjectNode json, OpenApi31Server node) {
        String value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "variables");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31ServerVariable model = (OpenApi31ServerVariable)node.createServerVariable();
                this.readServerVariable(mapValue, model);
                node.addVariable((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readServerVariable(ObjectNode json, OpenApi31ServerVariable node) {
        Object value = JsonUtil.consumeStringArrayProperty(json, "enum");
        node.setEnum((List<String>)value);
        value = JsonUtil.consumeStringProperty(json, "default");
        node.setDefault((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readComponents(ObjectNode json, OpenApi31Components node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "schemas");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Schema model = (OpenApi31Schema)node.createSchema();
                this.readSchema(mapValue, model);
                node.addSchema((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "responses");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Response model = (OpenApi31Response)node.createResponse();
                this.readResponse(mapValue, model);
                node.addResponse((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "parameters");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Parameter model = (OpenApi31Parameter)node.createParameter();
                this.readParameter(mapValue, model);
                node.addParameter((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "examples");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Example model = (OpenApi31Example)node.createExample();
                this.readExample(mapValue, model);
                node.addExample((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "requestBodies");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31RequestBody model = (OpenApi31RequestBody)node.createRequestBody();
                this.readRequestBody(mapValue, model);
                node.addRequestBody((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "headers");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Header model = (OpenApi31Header)node.createHeader();
                this.readHeader(mapValue, model);
                node.addHeader((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "securitySchemes");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31SecurityScheme model = (OpenApi31SecurityScheme)node.createSecurityScheme();
                this.readSecurityScheme(mapValue, model);
                node.addSecurityScheme((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "links");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Link model = (OpenApi31Link)node.createLink();
                this.readLink(mapValue, model);
                node.addLink((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "callbacks");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Callback model = (OpenApi31Callback)node.createCallback();
                this.readCallback(mapValue, model);
                node.addCallback((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "pathItems");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31PathItem model = node.createPathItem();
                this.readPathItem(mapValue, model);
                node.addPathItem((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readPaths(ObjectNode json, OpenApi31Paths node) {
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                OpenApi31PathItem model = (OpenApi31PathItem)node.createPathItem();
                this.readPathItem(object, model);
                node.addItem((String)name, model);
            }
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readPathItem(ObjectNode json, OpenApi31PathItem node) {
        List<ObjectNode> objects;
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "get");
        if (object2 != null) {
            node.setGet(node.createOperation());
            this.readOperation(object2, (OpenApi31Operation)node.getGet());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "put")) != null) {
            node.setPut(node.createOperation());
            this.readOperation(object2, (OpenApi31Operation)node.getPut());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "post")) != null) {
            node.setPost(node.createOperation());
            this.readOperation(object2, (OpenApi31Operation)node.getPost());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "delete")) != null) {
            node.setDelete(node.createOperation());
            this.readOperation(object2, (OpenApi31Operation)node.getDelete());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "options")) != null) {
            node.setOptions(node.createOperation());
            this.readOperation(object2, (OpenApi31Operation)node.getOptions());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "head")) != null) {
            node.setHead(node.createOperation());
            this.readOperation(object2, (OpenApi31Operation)node.getHead());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "patch")) != null) {
            node.setPatch(node.createOperation());
            this.readOperation(object2, (OpenApi31Operation)node.getPatch());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "trace")) != null) {
            node.setTrace(node.createOperation());
            this.readOperation(object2, node.getTrace());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "servers")) != null) {
            objects.forEach(object -> {
                OpenApi31Server model = node.createServer();
                this.readServer((ObjectNode)object, model);
                node.addServer(model);
            });
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "parameters")) != null) {
            objects.forEach(object -> {
                OpenApi31Parameter model = node.createParameter();
                this.readParameter((ObjectNode)object, model);
                node.addParameter(model);
            });
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOperation(ObjectNode json, OpenApi31Operation node) {
        Object value = JsonUtil.consumeStringArrayProperty(json, "tags");
        node.setTags((List<String>)value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "externalDocs");
        if (object2 != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, (OpenApi31ExternalDocumentation)node.getExternalDocs());
        }
        value = JsonUtil.consumeStringProperty(json, "operationId");
        node.setOperationId((String)value);
        List<ObjectNode> objects = JsonUtil.consumeObjectArrayProperty(json, "parameters");
        if (objects != null) {
            objects.forEach(object -> {
                OpenApi31Parameter model = node.createParameter();
                this.readParameter((ObjectNode)object, model);
                node.addParameter(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "requestBody")) != null) {
            node.setRequestBody(node.createRequestBody());
            this.readRequestBody(object2, node.getRequestBody());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "responses")) != null) {
            node.setResponses(node.createResponses());
            this.readResponses(object2, (OpenApi31Responses)node.getResponses());
        }
        object2 = JsonUtil.consumeObjectProperty(json, "callbacks");
        JsonUtil.keys(object2).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object2, name);
            if (mapValue != null) {
                OpenApi31Callback model = node.createCallback();
                this.readCallback(mapValue, model);
                node.addCallback((String)name, model);
            }
        });
        value = JsonUtil.consumeBooleanProperty(json, "deprecated");
        node.setDeprecated((Boolean)value);
        objects = JsonUtil.consumeObjectArrayProperty(json, "security");
        if (objects != null) {
            objects.forEach(object -> {
                OpenApi31SecurityRequirement model = node.createSecurityRequirement();
                this.readSecurityRequirement((ObjectNode)object, model);
                node.addSecurity(model);
            });
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "servers")) != null) {
            objects.forEach(object -> {
                OpenApi31Server model = node.createServer();
                this.readServer((ObjectNode)object, model);
                node.addServer(model);
            });
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readExternalDocumentation(ObjectNode json, OpenApi31ExternalDocumentation node) {
        String value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readParameter(ObjectNode json, OpenApi31Parameter node) {
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary((String)value);
        value = JsonUtil.consumeStringProperty(json, "name");
        node.setName((String)value);
        value = JsonUtil.consumeStringProperty(json, "in");
        node.setIn((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "required");
        node.setRequired((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "deprecated");
        node.setDeprecated((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "allowEmptyValue");
        node.setAllowEmptyValue((Boolean)value);
        value = JsonUtil.consumeStringProperty(json, "style");
        node.setStyle((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "explode");
        node.setExplode((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "allowReserved");
        node.setAllowReserved((Boolean)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "schema");
        if (object != null) {
            node.setSchema(node.createSchema());
            this.readSchema(object, (OpenApi31Schema)node.getSchema());
        }
        value = JsonUtil.consumeAnyProperty(json, "example");
        node.setExample((JsonNode)value);
        object = JsonUtil.consumeObjectProperty(json, "examples");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Example model = node.createExample();
                this.readExample(mapValue, model);
                node.addExample((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "content");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31MediaType model = node.createMediaType();
                this.readMediaType(mapValue, model);
                node.addContent((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readRequestBody(ObjectNode json, OpenApi31RequestBody node) {
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "content");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31MediaType model = (OpenApi31MediaType)node.createMediaType();
                this.readMediaType(mapValue, model);
                node.addContent((String)name, model);
            }
        });
        value = JsonUtil.consumeBooleanProperty(json, "required");
        node.setRequired((Boolean)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readMediaType(ObjectNode json, OpenApi31MediaType node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "schema");
        if (object != null) {
            node.setSchema(node.createSchema());
            this.readSchema(object, (OpenApi31Schema)node.getSchema());
        }
        JsonNode value = JsonUtil.consumeAnyProperty(json, "example");
        node.setExample(value);
        object = JsonUtil.consumeObjectProperty(json, "examples");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Example model = node.createExample();
                this.readExample(mapValue, model);
                node.addExample((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "encoding");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Encoding model = (OpenApi31Encoding)node.createEncoding();
                this.readEncoding(mapValue, model);
                node.addEncoding((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readEncoding(ObjectNode json, OpenApi31Encoding node) {
        Object value = JsonUtil.consumeStringProperty(json, "contentType");
        node.setContentType((String)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "headers");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Header model = node.createHeader();
                this.readHeader(mapValue, model);
                node.addHeader((String)name, model);
            }
        });
        value = JsonUtil.consumeStringProperty(json, "style");
        node.setStyle((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "explode");
        node.setExplode((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "allowReserved");
        node.setAllowReserved((Boolean)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readResponses(ObjectNode json, OpenApi31Responses node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "default");
        if (object != null) {
            node.setDefault(node.createResponse());
            this.readResponse(object, (OpenApi31Response)node.getDefault());
        }
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                OpenApi31Response model = (OpenApi31Response)node.createResponse();
                this.readResponse(object, model);
                node.addItem((String)name, model);
            }
        });
        propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readResponse(ObjectNode json, OpenApi31Response node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "headers");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Header model = node.createHeader();
                this.readHeader(mapValue, model);
                node.addHeader((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "content");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31MediaType model = node.createMediaType();
                this.readMediaType(mapValue, model);
                node.addContent((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "links");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Link model = node.createLink();
                this.readLink(mapValue, model);
                node.addLink((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readCallback(ObjectNode json, OpenApi31Callback node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                OpenApi31PathItem model = (OpenApi31PathItem)node.createPathItem();
                this.readPathItem(object, model);
                node.addItem((String)name, model);
            }
        });
        propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readExample(ObjectNode json, OpenApi31Example node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeAnyProperty(json, "value");
        node.setValue((JsonNode)value);
        value = JsonUtil.consumeStringProperty(json, "externalValue");
        node.setExternalValue(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readLink(ObjectNode json, OpenApi31Link node) {
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary((String)value);
        value = JsonUtil.consumeStringProperty(json, "operationRef");
        node.setOperationRef((String)value);
        value = JsonUtil.consumeStringProperty(json, "operationId");
        node.setOperationId((String)value);
        value = JsonUtil.consumeAnyMapProperty(json, "parameters");
        node.setParameters((Map<String, JsonNode>)value);
        value = JsonUtil.consumeAnyProperty(json, "requestBody");
        node.setRequestBody((JsonNode)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "server");
        if (object != null) {
            node.setServer(node.createServer());
            this.readServer(object, (OpenApi31Server)node.getServer());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readHeader(ObjectNode json, OpenApi31Header node) {
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "required");
        node.setRequired((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "deprecated");
        node.setDeprecated((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "allowEmptyValue");
        node.setAllowEmptyValue((Boolean)value);
        value = JsonUtil.consumeStringProperty(json, "style");
        node.setStyle((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "explode");
        node.setExplode((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "allowReserved");
        node.setAllowReserved((Boolean)value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "schema");
        if (object != null) {
            node.setSchema(node.createSchema());
            this.readSchema(object, node.getSchema());
        }
        value = JsonUtil.consumeAnyProperty(json, "example");
        node.setExample((JsonNode)value);
        object = JsonUtil.consumeObjectProperty(json, "examples");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31Example model = node.createExample();
                this.readExample(mapValue, model);
                node.addExample((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "content");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                OpenApi31MediaType model = node.createMediaType();
                this.readMediaType(mapValue, model);
                node.addContent((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readTag(ObjectNode json, OpenApi31Tag node) {
        String value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "externalDocs");
        if (object != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object, (OpenApi31ExternalDocumentation)node.getExternalDocs());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSchema(ObjectNode json, OpenApi31Schema node) {
        List<ObjectNode> objects;
        ObjectNode object2;
        PrimitiveUnionValueImpl unionValue;
        Object pValue;
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary((String)value);
        value = JsonUtil.consumeStringProperty(json, "format");
        node.setFormat((String)value);
        value = JsonUtil.consumeStringProperty(json, "title");
        node.setTitle((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        value = JsonUtil.consumeAnyProperty(json, "default");
        node.setDefault((JsonNode)value);
        value = JsonUtil.consumeNumberProperty(json, "multipleOf");
        node.setMultipleOf((Number)value);
        value = JsonUtil.consumeNumberProperty(json, "maximum");
        node.setMaximum((Number)value);
        value = JsonUtil.consumeNumberProperty(json, "exclusiveMaximum");
        node.setExclusiveMaximum((Number)value);
        value = JsonUtil.consumeNumberProperty(json, "minimum");
        node.setMinimum((Number)value);
        value = JsonUtil.consumeNumberProperty(json, "exclusiveMinimum");
        node.setExclusiveMinimum((Number)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxLength");
        node.setMaxLength((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minLength");
        node.setMinLength((Integer)value);
        value = JsonUtil.consumeStringProperty(json, "pattern");
        node.setPattern((String)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxItems");
        node.setMaxItems((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minItems");
        node.setMinItems((Integer)value);
        value = JsonUtil.consumeBooleanProperty(json, "uniqueItems");
        node.setUniqueItems((Boolean)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxProperties");
        node.setMaxProperties((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minProperties");
        node.setMinProperties((Integer)value);
        value = JsonUtil.consumeStringArrayProperty(json, "required");
        node.setRequired((List<String>)value);
        value = JsonUtil.consumeAnyArrayProperty(json, "enum");
        node.setEnum((List<JsonNode>)value);
        value = JsonUtil.consumeAnyProperty(json, "const");
        node.setConst((JsonNode)value);
        value = JsonUtil.consumeAnyProperty(json, "type");
        if (value != null) {
            if (JsonUtil.isArray(value)) {
                List<JsonNode> array = JsonUtil.toList(value);
                ArrayList<String> items = new ArrayList<String>();
                array.forEach(item -> {
                    String pValue = JsonUtil.toString(item);
                    items.add(pValue);
                });
                StringListUnionValueImpl unionValue2 = new StringListUnionValueImpl((List<String>)items);
                node.setType(unionValue2);
            } else if (JsonUtil.isString(value)) {
                pValue = JsonUtil.toString(value);
                unionValue = new StringUnionValueImpl((String)pValue);
                node.setType((StringStringListUnion)((Object)unionValue));
            } else {
                node.addExtraProperty("type", (JsonNode)value);
            }
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "items")) != null) {
            node.setItems(node.createSchema());
            this.readSchema(object2, node.getItems());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "allOf")) != null) {
            objects.forEach(object -> {
                OpenApi31Schema model = node.createSchema();
                this.readSchema((ObjectNode)object, model);
                node.addAllOf(model);
            });
        }
        object2 = JsonUtil.consumeObjectProperty(json, "properties");
        JsonUtil.keys(object2).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object2, name);
            if (mapValue != null) {
                OpenApi31Schema model = node.createSchema();
                this.readSchema(mapValue, model);
                node.addProperty((String)name, model);
            }
        });
        value = JsonUtil.consumeAnyProperty(json, "additionalProperties");
        if (value != null) {
            if (JsonUtil.isObject(value)) {
                ObjectNode object3 = JsonUtil.toObject(value);
                node.setAdditionalProperties(node.createSchema());
                this.readSchema(object3, (OpenApi31Schema)node.getAdditionalProperties());
            } else if (JsonUtil.isBoolean(value)) {
                pValue = JsonUtil.toBoolean(value);
                unionValue = new BooleanUnionValueImpl((Boolean)pValue);
                node.setAdditionalProperties((BooleanSchemaUnion)((Object)unionValue));
            } else {
                node.addExtraProperty("additionalProperties", (JsonNode)value);
            }
        }
        value = JsonUtil.consumeBooleanProperty(json, "readOnly");
        node.setReadOnly((Boolean)value);
        object2 = JsonUtil.consumeObjectProperty(json, "xml");
        if (object2 != null) {
            node.setXml(node.createXML());
            this.readXML(object2, (OpenApi31XML)node.getXml());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "externalDocs")) != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, (OpenApi31ExternalDocumentation)node.getExternalDocs());
        }
        value = JsonUtil.consumeAnyProperty(json, "example");
        node.setExample((JsonNode)value);
        objects = JsonUtil.consumeObjectArrayProperty(json, "oneOf");
        if (objects != null) {
            objects.forEach(object -> {
                OpenApi31Schema model = node.createSchema();
                this.readSchema((ObjectNode)object, model);
                node.addOneOf(model);
            });
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "anyOf")) != null) {
            objects.forEach(object -> {
                OpenApi31Schema model = node.createSchema();
                this.readSchema((ObjectNode)object, model);
                node.addAnyOf(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "not")) != null) {
            node.setNot(node.createSchema());
            this.readSchema(object2, node.getNot());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "discriminator")) != null) {
            node.setDiscriminator(node.createDiscriminator());
            this.readDiscriminator(object2, node.getDiscriminator());
        }
        value = JsonUtil.consumeBooleanProperty(json, "writeOnly");
        node.setWriteOnly((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "deprecated");
        node.setDeprecated((Boolean)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readDiscriminator(ObjectNode json, OpenApi31Discriminator node) {
        Object value = JsonUtil.consumeStringProperty(json, "propertyName");
        node.setPropertyName((String)value);
        value = JsonUtil.consumeStringMapProperty(json, "mapping");
        node.setMapping((Map<String, String>)value);
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readXML(ObjectNode json, OpenApi31XML node) {
        Object value = JsonUtil.consumeStringProperty(json, "name");
        node.setName((String)value);
        value = JsonUtil.consumeStringProperty(json, "namespace");
        node.setNamespace((String)value);
        value = JsonUtil.consumeStringProperty(json, "prefix");
        node.setPrefix((String)value);
        value = JsonUtil.consumeBooleanProperty(json, "attribute");
        node.setAttribute((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "wrapped");
        node.setWrapped((Boolean)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSecurityScheme(ObjectNode json, OpenApi31SecurityScheme node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary(value);
        value = JsonUtil.consumeStringProperty(json, "type");
        node.setType(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "in");
        node.setIn(value);
        value = JsonUtil.consumeStringProperty(json, "scheme");
        node.setScheme(value);
        value = JsonUtil.consumeStringProperty(json, "bearerFormat");
        node.setBearerFormat(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "flows");
        if (object != null) {
            node.setFlows(node.createOAuthFlows());
            this.readOAuthFlows(object, node.getFlows());
        }
        value = JsonUtil.consumeStringProperty(json, "openIdConnectUrl");
        node.setOpenIdConnectUrl(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOAuthFlows(ObjectNode json, OpenApi31OAuthFlows node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "implicit");
        if (object != null) {
            node.setImplicit(node.createOAuthFlow());
            this.readOAuthFlow(object, (OpenApi31OAuthFlow)node.getImplicit());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "password")) != null) {
            node.setPassword(node.createOAuthFlow());
            this.readOAuthFlow(object, (OpenApi31OAuthFlow)node.getPassword());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "clientCredentials")) != null) {
            node.setClientCredentials(node.createOAuthFlow());
            this.readOAuthFlow(object, (OpenApi31OAuthFlow)node.getClientCredentials());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "authorizationCode")) != null) {
            node.setAuthorizationCode(node.createOAuthFlow());
            this.readOAuthFlow(object, (OpenApi31OAuthFlow)node.getAuthorizationCode());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOAuthFlow(ObjectNode json, OpenApi31OAuthFlow node) {
        Object value = JsonUtil.consumeStringProperty(json, "authorizationUrl");
        node.setAuthorizationUrl((String)value);
        value = JsonUtil.consumeStringProperty(json, "tokenUrl");
        node.setTokenUrl((String)value);
        value = JsonUtil.consumeStringProperty(json, "refreshUrl");
        node.setRefreshUrl((String)value);
        value = JsonUtil.consumeStringMapProperty(json, "scopes");
        node.setScopes((Map<String, String>)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSecurityRequirement(ObjectNode json, OpenApi31SecurityRequirement node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            List<String> value = JsonUtil.consumeStringArrayProperty(json, name);
            node.addItem((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }
}

