/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.util;

import java.io.PrintStream;

public class LoggerUtil {
    private static void output(String prefix, PrintStream stream, String message, Object ... args) {
        stream.print("|");
        stream.print(prefix);
        stream.print("| ");
        stream.print(LoggerUtil.formatMessage(message, args));
        stream.println("");
    }

    private static String formatMessage(String message, Object[] args) {
        int idx;
        boolean done = false;
        Object rval = message;
        int argidx = 0;
        while (!done && (idx = ((String)rval).indexOf("%")) != -1) {
            rval = ((String)rval).substring(0, idx) + String.valueOf(args[argidx++]) + ((String)rval).substring(idx + 2);
        }
        return rval;
    }

    public static void info(String message, Object ... args) {
        LoggerUtil.output("INFO", System.out, message, args);
    }

    public static void warn(String message, Object ... args) {
        LoggerUtil.output("WARN", System.err, message, args);
    }

    public static void debug(String message, Object ... args) {
        LoggerUtil.output("DEBUG", System.out, message, args);
    }
}

