/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.openapi.OpenApiEncoding;
import io.apicurio.datamodels.models.openapi.OpenApiHeadersParent;
import io.apicurio.datamodels.models.openapi.OpenApiMediaType;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;

public class OasUnexpectedHeaderUsageRule
extends AbstractInvalidPropertyValueRule {
    private String mediaTypeName;

    public OasUnexpectedHeaderUsageRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitMediaType(OpenApiMediaType node) {
        this.mediaTypeName = this.getMappedNodeName(node);
    }

    @Override
    public void visitEncoding(OpenApiEncoding node) {
        OpenApiHeadersParent headersParent = (OpenApiHeadersParent)((Object)node);
        if (this.isDefined(headersParent.getHeaders()) && !headersParent.getHeaders().isEmpty()) {
            this.reportIfInvalid(this.mediaTypeName.indexOf("multipart") == 0, node, "headers", this.map("name", this.mediaTypeName));
        }
    }
}

