/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.other;

import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.models.openapi.OpenApiParametersParent;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import java.util.List;

public class OasBodyParameterUniquenessValidationRule
extends ValidationRule {
    public OasBodyParameterUniquenessValidationRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitParameter(Parameter node) {
        OpenApiParameter param = (OpenApiParameter)node;
        if (this.equals(param.getIn(), "body")) {
            List<OpenApiParameter> params = ((OpenApiParametersParent)((Object)node.parent())).getParameters();
            int count = this.countBodyParams(params);
            this.reportIf(count > 1, node, "in", this.map(new String[0]));
        }
    }

    private int countBodyParams(List<OpenApiParameter> params) {
        int count = 0;
        if (this.isDefined(params)) {
            for (OpenApiParameter parameter : params) {
                if (!this.equals(parameter.getIn(), "body")) continue;
                ++count;
            }
        }
        return count;
    }
}

