/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.other;

import io.apicurio.datamodels.models.SecurityRequirement;
import io.apicurio.datamodels.models.SecurityRequirementsParent;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SecurityRequirementUniquenessValidationRule
extends ValidationRule {
    public SecurityRequirementUniquenessValidationRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private static boolean isEqualTo(SecurityRequirement currentSecurityRequirement, SecurityRequirement otherSecurityRequirement) {
        List<String> currentSecurityRequirementNames = currentSecurityRequirement.getItemNames();
        List<String> otherSecurityRequirementNames = otherSecurityRequirement.getItemNames();
        Collections.sort(currentSecurityRequirementNames);
        Collections.sort(otherSecurityRequirementNames);
        if (!currentSecurityRequirementNames.equals(otherSecurityRequirementNames)) {
            return false;
        }
        for (String secReqName : currentSecurityRequirementNames) {
            List secReqScopes = (List)currentSecurityRequirement.getItem(secReqName);
            List otherSecReqScopes = (List)otherSecurityRequirement.getItem(secReqName);
            Collections.sort(secReqScopes);
            Collections.sort(otherSecReqScopes);
            if (secReqScopes.equals(otherSecReqScopes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkForDuplicates(SecurityRequirement currentSecurityRequirement, List<? extends SecurityRequirement> allRequirements) {
        ArrayList<? extends SecurityRequirement> clonedList = new ArrayList<SecurityRequirement>(allRequirements);
        clonedList.remove(currentSecurityRequirement);
        for (SecurityRequirement securityRequirement : clonedList) {
            if (!SecurityRequirementUniquenessValidationRule.isEqualTo(currentSecurityRequirement, securityRequirement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        SecurityRequirementsParent parent = (SecurityRequirementsParent)((Object)node.parent());
        List<SecurityRequirement> securityRequirements = parent.getSecurity();
        if (securityRequirements.size() <= 1) {
            return;
        }
        if (SecurityRequirementUniquenessValidationRule.checkForDuplicates(node, securityRequirements)) {
            this.report(node, "security", this.map("securityReq", node.getItemNames().toString()));
        }
    }
}

