/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.openapi.OpenApiExample;
import io.apicurio.datamodels.models.openapi.OpenApiExamplesParent;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Example;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Example;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;
import io.apicurio.datamodels.util.ModelTypeUtil;

public class AddExampleCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public JsonNode _newExampleValue;
    public String _newExampleName;
    public String _newExampleSummary;
    public String _newExampleDescription;
    public boolean _exampleAdded;

    public AddExampleCommand() {
    }

    public AddExampleCommand(OpenApiExamplesParent parent, JsonNode example, String exampleName, String exampleSummary, String exampleDescription) {
        this._parentPath = NodePathUtil.createNodePath((Node)((Object)parent));
        this._newExampleValue = example;
        this._newExampleName = exampleName;
        this._newExampleSummary = exampleSummary;
        this._newExampleDescription = exampleDescription;
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[AddExampleCommand_30] Executing.", new Object[0]);
        this._exampleAdded = false;
        OpenApiExamplesParent examplesParent = (OpenApiExamplesParent)((Object)NodePathUtil.resolveNodePath(this._parentPath, document));
        if (this.isNullOrUndefined(examplesParent)) {
            return;
        }
        if (!this.isNullOrUndefined(examplesParent.getExamples()) && examplesParent.getExamples().containsKey(this._newExampleName)) {
            return;
        }
        OpenApiExample example = examplesParent.createExample();
        if (ModelTypeUtil.isOpenApi30Model(example)) {
            OpenApi30Example example3 = (OpenApi30Example)example;
            example3.setDescription(this._newExampleDescription);
            example3.setSummary(this._newExampleSummary);
            example3.setValue(this._newExampleValue);
        } else if (ModelTypeUtil.isOpenApi31Model(example)) {
            OpenApi31Example example3 = (OpenApi31Example)example;
            example3.setDescription(this._newExampleDescription);
            example3.setSummary(this._newExampleSummary);
            example3.setValue(this._newExampleValue);
        }
        examplesParent.addExample(this._newExampleName, example);
        this._exampleAdded = true;
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[AddExampleCommand_30] Reverting.", new Object[0]);
        if (!this._exampleAdded) {
            return;
        }
        OpenApiExamplesParent parent = (OpenApiExamplesParent)((Object)NodePathUtil.resolveNodePath(this._parentPath, document));
        if (this.isNullOrUndefined(parent) || this.isNullOrUndefined(parent.getExamples())) {
            return;
        }
        parent.removeExample(this._newExampleName);
    }
}

