/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import io.apicurio.datamodels.models.openapi.OpenApiResponse;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Document;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Response;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Document;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Response;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Document;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Response;
import io.apicurio.datamodels.util.LoggerUtil;
import io.apicurio.datamodels.util.ModelTypeUtil;

public class AddResponseDefinitionCommand
extends AbstractCommand {
    public boolean _defExisted;
    public String _newDefinitionName;
    public ObjectNode _newDefinitionObj;
    public boolean _nullDefinitionsParent;
    private transient AddResponseDefinitionCommandHelper _helper;

    public AddResponseDefinitionCommand() {
    }

    public AddResponseDefinitionCommand(String definitionName, ObjectNode obj) {
        this._newDefinitionName = definitionName;
        this._newDefinitionObj = obj;
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[AddResponseDefinitionCommand] Executing.", new Object[0]);
        this._helper = this.createHelper(document);
        OpenApiDocument doc = (OpenApiDocument)document;
        if (this._helper.defExists(doc)) {
            LoggerUtil.info("[AddResponseDefinitionCommand] Definition with name %s already exists.", this._newDefinitionName);
            this._defExisted = true;
            return;
        }
        this._nullDefinitionsParent = this._helper.prepareDocumentForDef(doc);
        OpenApiResponse definition = this._helper.createResponseDefinition(doc);
        this._helper.addDefinition(doc, definition);
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[AddResponseDefinitionCommand] Reverting.", new Object[0]);
        if (this._defExisted) {
            return;
        }
        this._helper = this.createHelper(document);
        OpenApiDocument doc = (OpenApiDocument)document;
        this._helper.removeDefinition(doc);
    }

    private AddResponseDefinitionCommandHelper createHelper(Document document) {
        if (ModelTypeUtil.isOpenApi2Model(document)) {
            return new OpenApi20Helper();
        }
        if (ModelTypeUtil.isOpenApi30Model(document)) {
            return new OpenApi30Helper();
        }
        if (ModelTypeUtil.isOpenApi31Model(document)) {
            return new OpenApi31Helper();
        }
        throw new RuntimeException("Unsupported model type: " + String.valueOf((Object)document.root().modelType()));
    }

    private class OpenApi31Helper
    implements AddResponseDefinitionCommandHelper {
        private OpenApi31Helper() {
        }

        @Override
        public boolean defExists(OpenApiDocument document) {
            OpenApi31Document doc31 = (OpenApi31Document)document;
            if (AddResponseDefinitionCommand.this.isNullOrUndefined(doc31.getComponents())) {
                return false;
            }
            return !AddResponseDefinitionCommand.this.isNullOrUndefined(doc31.getComponents().getResponses().get(AddResponseDefinitionCommand.this._newDefinitionName));
        }

        @Override
        public boolean prepareDocumentForDef(OpenApiDocument document) {
            OpenApi31Document doc31 = (OpenApi31Document)document;
            if (AddResponseDefinitionCommand.this.isNullOrUndefined(doc31.getComponents())) {
                doc31.setComponents(doc31.createComponents());
                return true;
            }
            return false;
        }

        @Override
        public OpenApiResponse createResponseDefinition(OpenApiDocument document) {
            OpenApi31Document doc31 = (OpenApi31Document)document;
            OpenApi31Response definition = (OpenApi31Response)doc31.getComponents().createResponse();
            Library.readNode(AddResponseDefinitionCommand.this._newDefinitionObj, definition);
            return definition;
        }

        @Override
        public void addDefinition(OpenApiDocument document, OpenApiResponse definition) {
            OpenApi31Document doc31 = (OpenApi31Document)document;
            doc31.getComponents().addResponse(AddResponseDefinitionCommand.this._newDefinitionName, definition);
        }

        @Override
        public void removeDefinition(OpenApiDocument document) {
            OpenApi31Document doc31 = (OpenApi31Document)document;
            if (AddResponseDefinitionCommand.this._nullDefinitionsParent) {
                doc31.setComponents(null);
            } else {
                doc31.getComponents().removeResponse(AddResponseDefinitionCommand.this._newDefinitionName);
            }
        }
    }

    private class OpenApi30Helper
    implements AddResponseDefinitionCommandHelper {
        private OpenApi30Helper() {
        }

        @Override
        public boolean defExists(OpenApiDocument document) {
            OpenApi30Document doc30 = (OpenApi30Document)document;
            if (AddResponseDefinitionCommand.this.isNullOrUndefined(doc30.getComponents())) {
                return false;
            }
            return !AddResponseDefinitionCommand.this.isNullOrUndefined(doc30.getComponents().getResponses().get(AddResponseDefinitionCommand.this._newDefinitionName));
        }

        @Override
        public boolean prepareDocumentForDef(OpenApiDocument document) {
            OpenApi30Document doc30 = (OpenApi30Document)document;
            if (AddResponseDefinitionCommand.this.isNullOrUndefined(doc30.getComponents())) {
                doc30.setComponents(doc30.createComponents());
                return true;
            }
            return false;
        }

        @Override
        public OpenApiResponse createResponseDefinition(OpenApiDocument document) {
            OpenApi30Document doc30 = (OpenApi30Document)document;
            OpenApi30Response definition = (OpenApi30Response)doc30.getComponents().createResponse();
            Library.readNode(AddResponseDefinitionCommand.this._newDefinitionObj, definition);
            return definition;
        }

        @Override
        public void addDefinition(OpenApiDocument document, OpenApiResponse definition) {
            OpenApi30Document doc30 = (OpenApi30Document)document;
            doc30.getComponents().addResponse(AddResponseDefinitionCommand.this._newDefinitionName, definition);
        }

        @Override
        public void removeDefinition(OpenApiDocument document) {
            OpenApi30Document doc30 = (OpenApi30Document)document;
            if (AddResponseDefinitionCommand.this._nullDefinitionsParent) {
                doc30.setComponents(null);
            } else {
                doc30.getComponents().removeResponse(AddResponseDefinitionCommand.this._newDefinitionName);
            }
        }
    }

    private class OpenApi20Helper
    implements AddResponseDefinitionCommandHelper {
        private OpenApi20Helper() {
        }

        @Override
        public boolean defExists(OpenApiDocument document) {
            OpenApi20Document doc = (OpenApi20Document)document;
            if (!AddResponseDefinitionCommand.this.isNullOrUndefined(doc.getResponses())) {
                return !AddResponseDefinitionCommand.this.isNullOrUndefined(doc.getResponses().getItem(AddResponseDefinitionCommand.this._newDefinitionName));
            }
            return false;
        }

        @Override
        public boolean prepareDocumentForDef(OpenApiDocument document) {
            OpenApi20Document doc20 = (OpenApi20Document)document;
            if (AddResponseDefinitionCommand.this.isNullOrUndefined(doc20.getResponses())) {
                doc20.setResponses(doc20.createResponseDefinitions());
                return true;
            }
            return false;
        }

        @Override
        public OpenApiResponse createResponseDefinition(OpenApiDocument document) {
            OpenApi20Document doc20 = (OpenApi20Document)document;
            OpenApi20Response definition = doc20.getResponses().createResponse();
            Library.readNode(AddResponseDefinitionCommand.this._newDefinitionObj, definition);
            return definition;
        }

        @Override
        public void addDefinition(OpenApiDocument document, OpenApiResponse definition) {
            OpenApi20Document doc20 = (OpenApi20Document)document;
            OpenApi20Response def20 = (OpenApi20Response)definition;
            doc20.getResponses().addItem(AddResponseDefinitionCommand.this._newDefinitionName, def20);
        }

        @Override
        public void removeDefinition(OpenApiDocument document) {
            OpenApi20Document doc20 = (OpenApi20Document)document;
            if (AddResponseDefinitionCommand.this._nullDefinitionsParent) {
                doc20.setResponses(null);
            } else {
                doc20.getResponses().removeItem(AddResponseDefinitionCommand.this._newDefinitionName);
            }
        }
    }

    private static interface AddResponseDefinitionCommandHelper {
        public boolean defExists(OpenApiDocument var1);

        public boolean prepareDocumentForDef(OpenApiDocument var1);

        public OpenApiResponse createResponseDefinition(OpenApiDocument var1);

        public void addDefinition(OpenApiDocument var1, OpenApiResponse var2);

        public void removeDefinition(OpenApiDocument var1);
    }
}

