/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.SecurityRequirement;
import io.apicurio.datamodels.models.SecurityRequirementsParent;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;
import java.util.List;

public class AddSecurityRequirementCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public ObjectNode _requirement;
    public boolean _added;

    public AddSecurityRequirementCommand() {
    }

    public AddSecurityRequirementCommand(SecurityRequirementsParent parent, SecurityRequirement requirement) {
        this._parentPath = Library.createNodePath((Node)((Object)parent));
        this._requirement = Library.writeNode(requirement);
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[AddSecurityRequirementCommand] Executing.", new Object[0]);
        this._added = false;
        SecurityRequirementsParent parent = (SecurityRequirementsParent)((Object)NodePathUtil.resolveNodePath(this._parentPath, document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        SecurityRequirement requirement = parent.createSecurityRequirement();
        Library.readNode(this._requirement, requirement);
        parent.addSecurity(requirement);
        this._added = true;
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[AddSecurityRequirementCommand] Reverting.", new Object[0]);
        if (!this._added) {
            return;
        }
        SecurityRequirementsParent parent = (SecurityRequirementsParent)((Object)NodePathUtil.resolveNodePath(this._parentPath, document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        List<SecurityRequirement> security = parent.getSecurity();
        if (this.isNullOrUndefined(security)) {
            LoggerUtil.info("[AddSecurityRequirementCommand] Security requirement not found, skipping undo.", new Object[0]);
            return;
        }
        SecurityRequirement requirement = parent.createSecurityRequirement();
        Library.readNode(this._requirement, requirement);
        int idx = this.indexOfRequirement(security, requirement);
        if (idx != -1) {
            security.remove(idx);
        }
    }

    protected int indexOfRequirement(List<SecurityRequirement> requirements, SecurityRequirement requirement) {
        int idx = 0;
        for (SecurityRequirement r : requirements) {
            if (this.isEqual(r, requirement)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    protected boolean isEqual(SecurityRequirement req1, SecurityRequirement req2) {
        List<String> names1 = req1.getItemNames();
        List<String> names2 = req2.getItemNames();
        if (names1.size() != names2.size()) {
            return false;
        }
        boolean rval = true;
        for (String name1 : names1) {
            if (names2.indexOf(name1) != -1 && this.areScopesEqual((List)req1.getItem(name1), (List)req2.getItem(name1))) continue;
            rval = false;
        }
        return rval;
    }

    protected boolean areScopesEqual(List<String> scopes1, List<String> scopes2) {
        if (scopes1.size() != scopes2.size()) {
            return false;
        }
        boolean rval = true;
        for (String scope1 : scopes1) {
            if (scopes2.indexOf(scope1) != -1) continue;
            rval = false;
        }
        return rval;
    }
}

