/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.ICommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.util.LoggerUtil;
import java.util.List;

public class AggregateCommand
extends AbstractCommand {
    public String name;
    public ObjectNode info;
    public List<ICommand> _commands;

    public AggregateCommand() {
    }

    public AggregateCommand(String name, ObjectNode info, List<ICommand> commands) {
        this.name = name;
        this.info = info;
        this._commands = commands;
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[AggregateCommand] Executing %d child commands.", this._commands.size());
        this._commands.forEach(command -> command.execute(document));
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[AggregateCommand] Reverting %d child commands.", this._commands.size());
        for (int idx = this._commands.size() - 1; idx >= 0; --idx) {
            ICommand command = this._commands.get(idx);
            command.undo(document);
        }
    }
}

