/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.AbstractSchemaInhCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Schema;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Schema;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.util.NodeUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DeleteAllChildSchemasCommand
extends AbstractSchemaInhCommand {
    public NodePath _schemaPath;
    public String _childSchemaType;
    public List<ObjectNode> _oldSchemas;

    public DeleteAllChildSchemasCommand() {
    }

    public DeleteAllChildSchemasCommand(Schema parent, String type) {
        this._schemaPath = NodePathUtil.createNodePath(parent);
        this._childSchemaType = type;
    }

    @Override
    public void execute(Document document) {
        Schema s;
        int i;
        LoggerUtil.info("[DeleteAllChildSchemasCommand] Executing.", new Object[0]);
        this._oldSchemas = new ArrayList<ObjectNode>();
        Schema schema = (Schema)NodePathUtil.resolveNodePath(this._schemaPath, document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        AbstractList schemas = new ArrayList();
        if (NodeUtil.equals("allOf", this._childSchemaType)) {
            schemas = new LinkedList<Schema>(schema.getAllOf());
            for (i = 0; i < schemas.size(); ++i) {
                s = (Schema)schemas.get(i);
                if (!this.has$Ref(s)) continue;
                schema.removeAllOf(s);
                this.addOldSchema(s);
            }
            if (schema.getAllOf().isEmpty()) {
                NodeUtil.setProperty(schema, "allOf", null);
            }
        }
        if (NodeUtil.equals("anyOf", this._childSchemaType)) {
            schemas = new LinkedList<Schema>(this.getAnyOfSchemas(schema));
            for (i = 0; i < schemas.size(); ++i) {
                s = (Schema)schemas.get(i);
                if (!this.has$Ref(s)) continue;
                DeleteAllChildSchemasCommand.removeAnyOfSchema(schema, s);
                this.addOldSchema(s);
            }
            if (this.getAnyOfSchemas(schema).isEmpty()) {
                NodeUtil.setProperty(schema, "anyOf", null);
            }
        }
        if (NodeUtil.equals("oneOf", this._childSchemaType)) {
            schemas = new LinkedList<Schema>(this.getOneOfSchemas(schema));
            for (i = 0; i < schemas.size(); ++i) {
                s = (Schema)schemas.get(i);
                if (!this.has$Ref(s)) continue;
                DeleteAllChildSchemasCommand.removeOneOfSchema(schema, s);
                this.addOldSchema(s);
            }
            if (this.getOneOfSchemas(schema).isEmpty()) {
                NodeUtil.setProperty(schema, "oneOf", null);
            }
        }
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[DeleteAllChildSchemasCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldSchemas) || this._oldSchemas.size() == 0) {
            return;
        }
        Schema schema = (Schema)NodePathUtil.resolveNodePath(this._schemaPath, document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        this.copySchemaJsTo(this._oldSchemas, schema, this._childSchemaType);
    }

    private void addOldSchema(Schema schema) {
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        this._oldSchemas.add(Library.writeNode(schema));
    }

    private List<? extends Schema> getAnyOfSchemas(Schema schema) {
        if (ModelTypeUtil.isOpenApi30Model(schema)) {
            OpenApi30Schema schema30 = (OpenApi30Schema)schema;
            return schema30.getAnyOf();
        }
        if (ModelTypeUtil.isOpenApi31Model(schema)) {
            OpenApi31Schema schema31 = (OpenApi31Schema)schema;
            return schema31.getAnyOf();
        }
        if (ModelTypeUtil.isAsyncApiModel(schema)) {
            AsyncApiSchema s = (AsyncApiSchema)schema;
            return s.getAnyOf();
        }
        return null;
    }

    private List<? extends Schema> getOneOfSchemas(Schema schema) {
        if (ModelTypeUtil.isOpenApi30Model(schema)) {
            OpenApi30Schema schema30 = (OpenApi30Schema)schema;
            return schema30.getOneOf();
        }
        if (ModelTypeUtil.isOpenApi31Model(schema)) {
            OpenApi31Schema schema31 = (OpenApi31Schema)schema;
            return schema31.getOneOf();
        }
        if (ModelTypeUtil.isAsyncApiModel(schema)) {
            AsyncApiSchema s = (AsyncApiSchema)schema;
            return s.getOneOf();
        }
        return null;
    }

    private static void removeAnyOfSchema(Schema parent, Schema child) {
        if (ModelTypeUtil.isOpenApi30Model(parent)) {
            OpenApi30Schema schema30 = (OpenApi30Schema)parent;
            schema30.removeAnyOf((OpenApi30Schema)child);
        } else if (ModelTypeUtil.isOpenApi31Model(parent)) {
            OpenApi31Schema schema31 = (OpenApi31Schema)parent;
            schema31.removeAnyOf((OpenApi31Schema)child);
        } else if (ModelTypeUtil.isAsyncApiModel(parent)) {
            AsyncApiSchema schema = (AsyncApiSchema)parent;
            schema.removeAnyOf((AsyncApiSchema)child);
        }
    }

    private static void removeOneOfSchema(Schema parent, Schema child) {
        if (ModelTypeUtil.isOpenApi30Model(parent)) {
            OpenApi30Schema schema30 = (OpenApi30Schema)parent;
            schema30.removeOneOf((OpenApi30Schema)child);
        } else if (ModelTypeUtil.isOpenApi31Model(parent)) {
            OpenApi31Schema schema31 = (OpenApi31Schema)parent;
            schema31.removeOneOf((OpenApi31Schema)child);
        } else if (ModelTypeUtil.isAsyncApiModel(parent)) {
            AsyncApiSchema schema = (AsyncApiSchema)parent;
            schema.removeOneOf((AsyncApiSchema)child);
        }
    }
}

