/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.openapi.OpenApiExample;
import io.apicurio.datamodels.models.openapi.OpenApiExamplesParent;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public class DeleteAllExamplesCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public Map<String, ObjectNode> _oldExamples;

    public DeleteAllExamplesCommand() {
    }

    public DeleteAllExamplesCommand(OpenApiExamplesParent parent) {
        this._parentPath = NodePathUtil.createNodePath((Node)((Object)parent));
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[DeleteAllExamplesCommand] Executing.", new Object[0]);
        if (this.isNullOrUndefined(document)) {
            LoggerUtil.debug("[DeleteAllExamplesCommand] Could not execute the command, invalid argument.", new Object[0]);
            return;
        }
        if (this.isNullOrUndefined(this._parentPath)) {
            LoggerUtil.debug("[DeleteAllExamplesCommand] Could not execute the command, problem when unmarshalling.", new Object[0]);
            return;
        }
        OpenApiExamplesParent parent = (OpenApiExamplesParent)((Object)NodePathUtil.resolveNodePath(this._parentPath, document));
        if (this.isNullOrUndefined(parent)) {
            LoggerUtil.debug("[DeleteAllExamplesCommand] Parent node not found.", new Object[0]);
            return;
        }
        this._oldExamples = new LinkedHashMap<String, ObjectNode>();
        parent.getExamples().keySet().forEach(k -> {
            OpenApiExample n = parent.getExamples().get(k);
            this._oldExamples.put((String)k, Library.writeNode(n));
        });
        parent.clearExamples();
    }

    @Override
    public void undo(Document document) {
        if (this.isNullOrUndefined(document)) {
            LoggerUtil.debug("[DeleteAllExamplesCommand] Could not revert the command, invalid argument.", new Object[0]);
            return;
        }
        if (this.isNullOrUndefined(this._parentPath)) {
            LoggerUtil.debug("[DeleteAllExamplesCommand] Could not revert the command, problem when unmarshalling.", new Object[0]);
            return;
        }
        LoggerUtil.info("[DeleteAllExamplesCommand] Reverting.", new Object[0]);
        OpenApiExamplesParent parent = (OpenApiExamplesParent)((Object)NodePathUtil.resolveNodePath(this._parentPath, document));
        if (this.isNullOrUndefined(parent)) {
            LoggerUtil.info("[DeleteAllExamplesCommand] No parent node found.", new Object[0]);
            return;
        }
        if (this.isNullOrUndefined(this._oldExamples)) {
            LoggerUtil.info("[DeleteAllExamplesCommand] Could not revert. Previous data is not available.", new Object[0]);
            return;
        }
        for (String k : this._oldExamples.keySet()) {
            OpenApiExample example = parent.createExample();
            Library.readNode(this._oldExamples.get(k), example);
            parent.addExample(k, example);
        }
    }
}

