/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DeleteAllPropertiesCommand
extends AbstractCommand {
    public NodePath _schemaPath;
    public Map<String, ObjectNode> _oldProperties;
    public List<String> _oldRequired;

    public DeleteAllPropertiesCommand() {
    }

    public DeleteAllPropertiesCommand(Schema schema) {
        this._schemaPath = Library.createNodePath(schema);
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[DeleteAllPropertiesCommand] Executing.", new Object[0]);
        this._oldProperties = new LinkedHashMap<String, ObjectNode>();
        this._oldRequired = new ArrayList<String>();
        Schema schema = (Schema)NodePathUtil.resolveNodePath(this._schemaPath, document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.addAll(schema.getProperties().keySet());
        propertyNames.forEach(pname -> {
            Schema pvalue = schema.getProperties().get(pname);
            this._oldProperties.put((String)pname, Library.writeNode(pvalue));
            if (this.isRequired(schema, (String)pname)) {
                this._oldRequired.add((String)pname);
            }
            schema.removeProperty((String)pname);
            this.removeRequired(schema, (String)pname);
        });
        if (schema.getRequired() != null && schema.getRequired().isEmpty()) {
            schema.setRequired(null);
        }
    }

    private void removeRequired(Schema schema, String pname) {
        if (schema.getRequired() != null) {
            schema.getRequired().remove(pname);
        }
    }

    private boolean isRequired(Schema schema, String pname) {
        return schema.getRequired() != null && schema.getRequired().contains(pname);
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[DeleteAllPropertiesCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldProperties) || this._oldProperties.isEmpty()) {
            return;
        }
        Schema schema = (Schema)NodePathUtil.resolveNodePath(this._schemaPath, document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        this._oldProperties.keySet().forEach(pname -> {
            Schema pschema = schema.createSchema();
            Library.readNode(this._oldProperties.get(pname), pschema);
            schema.addProperty((String)pname, pschema);
            if (this._oldRequired.contains(pname)) {
                this.addRequired(schema, (String)pname);
            }
        });
    }

    private void addRequired(Schema schema, String pname) {
        if (schema.getRequired() == null) {
            schema.setRequired(new ArrayList<String>());
        }
        if (!schema.getRequired().contains(pname)) {
            schema.getRequired().add(pname);
        }
    }
}

