/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.SecurityRequirement;
import io.apicurio.datamodels.models.SecurityRequirementsParent;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.util.LoggerUtil;
import io.apicurio.datamodels.util.NodeUtil;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllSecurityRequirementsCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public List<ObjectNode> _oldSecurityRequirements;

    public DeleteAllSecurityRequirementsCommand() {
    }

    public DeleteAllSecurityRequirementsCommand(Node parent) {
        this._parentPath = Library.createNodePath(parent);
    }

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[DeleteAllSecurityRequirementsCommand] Executing.", new Object[0]);
        this._oldSecurityRequirements = new ArrayList<ObjectNode>();
        Node parent = NodePathUtil.resolveNodePath(this._parentPath, document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        List requirements = (List)NodeUtil.getProperty(parent, "security");
        if (!this.isNullOrUndefined(requirements)) {
            requirements.forEach(req -> this._oldSecurityRequirements.add(Library.writeNode(req)));
        }
        this.clearSecurityRequirements((SecurityRequirementsParent)((Object)parent));
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[DeleteAllSecurityRequirementsCommand] Reverting.", new Object[0]);
        if (NodeUtil.isDefined(this._oldSecurityRequirements) && this._oldSecurityRequirements.isEmpty()) {
            return;
        }
        Node parent = NodePathUtil.resolveNodePath(this._parentPath, document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        ArrayList requirements = (ArrayList)NodeUtil.getProperty(parent, "security");
        if (this.isNullOrUndefined(requirements)) {
            requirements = new ArrayList();
            NodeUtil.setProperty(parent, "security", requirements);
        }
        for (ObjectNode oldSecurityRequirement : this._oldSecurityRequirements) {
            SecurityRequirement requirement = this.createSecurityRequirement((SecurityRequirementsParent)((Object)parent));
            Library.readNode(oldSecurityRequirement, requirement);
            this.addSecurityRequirement((SecurityRequirementsParent)((Object)parent), requirement);
        }
    }

    private void clearSecurityRequirements(SecurityRequirementsParent parent) {
        parent.clearSecurity();
    }

    private SecurityRequirement createSecurityRequirement(SecurityRequirementsParent parent) {
        return parent.createSecurityRequirement();
    }

    private void addSecurityRequirement(SecurityRequirementsParent parent, SecurityRequirement requirement) {
        parent.addSecurity(requirement);
    }
}

