/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import io.apicurio.datamodels.models.openapi.OpenApiTag;
import io.apicurio.datamodels.util.LoggerUtil;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllTagsCommand
extends AbstractCommand {
    public List<ObjectNode> _oldTags;

    @Override
    public void execute(Document document) {
        LoggerUtil.info("[DeleteAllTagsCommand] Executing.", new Object[0]);
        OpenApiDocument doc = (OpenApiDocument)document;
        this._oldTags = new ArrayList<ObjectNode>();
        List<OpenApiTag> tags = doc.getTags();
        if (!this.isNullOrUndefined(tags)) {
            tags.forEach(tag -> this._oldTags.add(Library.writeNode(tag)));
        }
        doc.clearTags();
    }

    @Override
    public void undo(Document document) {
        LoggerUtil.info("[DeleteAllTagsCommand] Reverting.", new Object[0]);
        if (this._oldTags.isEmpty()) {
            return;
        }
        OpenApiDocument doc = (OpenApiDocument)document;
        this._oldTags.forEach(oldTag -> {
            OpenApiTag tag = doc.createTag();
            Library.readNode(oldTag, tag);
            doc.addTag(tag);
        });
    }
}

