/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.deref;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.TraverserDirection;
import io.apicurio.datamodels.VisitorUtil;
import io.apicurio.datamodels.deref.AsyncApi2NodeImporter;
import io.apicurio.datamodels.deref.InlineOrImportVisitor;
import io.apicurio.datamodels.deref.InternalRefResolverVisitor;
import io.apicurio.datamodels.deref.OpenApi2NodeImporter;
import io.apicurio.datamodels.deref.OpenApi3NodeImporter;
import io.apicurio.datamodels.deref.ReferencedNodeImporter;
import io.apicurio.datamodels.deref.SetContextVisitor;
import io.apicurio.datamodels.deref.UnresolvedReferenceNodeVisitor;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Referenceable;
import io.apicurio.datamodels.refs.IReferenceResolver;
import io.apicurio.datamodels.refs.Reference;
import io.apicurio.datamodels.refs.ReferenceContext;
import io.apicurio.datamodels.util.ModelTypeUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Dereferencer {
    private IReferenceResolver resolver;
    private boolean strict;

    public Dereferencer(IReferenceResolver resolver, boolean strict) {
        this.resolver = resolver;
        this.strict = strict;
    }

    public Document dereference(Document source) {
        Document doc = Library.cloneDocument(source);
        HashMap<Reference, String> rnm = new HashMap<Reference, String>();
        InternalRefResolverVisitor irrv = new InternalRefResolverVisitor();
        VisitorUtil.visitTree(doc, irrv, TraverserDirection.down);
        int unresolveableRefCount = 0;
        boolean isDone = false;
        do {
            UnresolvedReferenceNodeVisitor visitor = new UnresolvedReferenceNodeVisitor();
            VisitorUtil.visitTree(doc, visitor, TraverserDirection.down);
            List<Node> nodesWithUnresolvedRefs = visitor.getNodesWithUnresolvedRefs();
            if (nodesWithUnresolvedRefs.isEmpty()) {
                isDone = true;
                continue;
            }
            for (Node nodeWithUnresolvedRef : nodesWithUnresolvedRefs) {
                if (this.resolveNodeWithRef(doc, rnm, nodeWithUnresolvedRef)) continue;
                ++unresolveableRefCount;
            }
        } while (!isDone);
        if (this.strict && unresolveableRefCount > 0) {
            throw new RuntimeException("Could not resolve at least one external reference.");
        }
        return doc;
    }

    private boolean resolveNodeWithRef(Document doc, Map<Reference, String> rnm, Node nodeWithUnresolvedRef) {
        String ref = ((Referenceable)((Object)nodeWithUnresolvedRef)).get$ref();
        Reference reference = new Reference(ref);
        ReferenceContext refContext = (ReferenceContext)nodeWithUnresolvedRef.getNodeAttribute("apicurio-data-models.reference-context");
        if (refContext == null) {
            refContext = new ReferenceContext();
        }
        Reference canonicalReference = refContext.canonicalizeRef(reference);
        boolean inlined = false;
        String newRefValue = null;
        if (rnm.containsKey(canonicalReference)) {
            newRefValue = rnm.get(canonicalReference);
        } else {
            Node resolvedNode = this.resolver.resolveRef(canonicalReference.getRef(), nodeWithUnresolvedRef);
            if (resolvedNode == null) {
                nodeWithUnresolvedRef.setNodeAttribute("apicurio-data-models.resolved", "unresolveable");
                return false;
            }
            inlined = this.shouldInlineNode(nodeWithUnresolvedRef);
            ReferencedNodeImporter importer = this.createImporter(doc, nodeWithUnresolvedRef, ref, inlined);
            importer.importNode(resolvedNode);
            Node importedNode = importer.getImportedNode();
            newRefValue = importer.getPathToImportedNode();
            ReferenceContext resolvedNodeRefContext = refContext.append(reference);
            SetContextVisitor scv = new SetContextVisitor(resolvedNodeRefContext);
            VisitorUtil.visitTree(importedNode, scv, TraverserDirection.down);
            if (newRefValue != null) {
                rnm.put(canonicalReference, newRefValue);
            }
        }
        if (inlined) {
            ((Referenceable)((Object)nodeWithUnresolvedRef)).set$ref(null);
        } else {
            ((Referenceable)((Object)nodeWithUnresolvedRef)).set$ref(newRefValue);
        }
        nodeWithUnresolvedRef.setNodeAttribute("apicurio-data-models.resolved", "resolved");
        return true;
    }

    private ReferencedNodeImporter createImporter(Document doc, Node nodeWithUnresolvedRef, String ref, boolean shouldInline) {
        if (ModelTypeUtil.isAsyncApiModel(doc)) {
            return new AsyncApi2NodeImporter(doc, nodeWithUnresolvedRef, ref, shouldInline);
        }
        if (ModelTypeUtil.isOpenApi2Model(doc)) {
            return new OpenApi2NodeImporter(doc, nodeWithUnresolvedRef, ref, shouldInline);
        }
        if (ModelTypeUtil.isOpenApi3Model(doc)) {
            return new OpenApi3NodeImporter(doc, nodeWithUnresolvedRef, ref, shouldInline);
        }
        throw new RuntimeException("Unsupported model type: " + String.valueOf((Object)doc.root().modelType()));
    }

    private boolean shouldInlineNode(Node nodeWithUnresolvedRef) {
        InlineOrImportVisitor viz = new InlineOrImportVisitor();
        nodeWithUnresolvedRef.accept(viz);
        return viz.shouldInline();
    }
}

