/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.asyncapi.v20.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.RootNode;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Binding;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ChannelBindings;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ChannelItem;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Channels;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Components;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Contact;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20CorrelationID;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Document;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20DocumentImpl;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ExternalDocumentation;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Info;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20License;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Message;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20MessageBindings;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20MessageTrait;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OAuthFlow;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OAuthFlows;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OneOfMessages;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Operation;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OperationBindings;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OperationTrait;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Parameter;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Parameters;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Schema;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20SecurityRequirement;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20SecurityScheme;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Server;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ServerBindings;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ServerVariable;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Servers;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Tag;
import io.apicurio.datamodels.models.io.ModelReader;
import io.apicurio.datamodels.models.union.BooleanUnionValueImpl;
import io.apicurio.datamodels.models.union.SchemaListUnionValueImpl;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.apicurio.datamodels.models.util.ReaderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AsyncApi20ModelReader
implements ModelReader {
    public void readDocument(ObjectNode json, AsyncApi20Document node) {
        List<ObjectNode> objects;
        String value = JsonUtil.consumeStringProperty(json, "asyncapi");
        node.setAsyncapi(value);
        value = JsonUtil.consumeStringProperty(json, "id");
        node.setId(value);
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "info");
        if (object2 != null) {
            node.setInfo(node.createInfo());
            this.readInfo(object2, (AsyncApi20Info)node.getInfo());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "servers")) != null) {
            node.setServers(node.createServers());
            this.readServers(object2, (AsyncApi20Servers)node.getServers());
        }
        value = JsonUtil.consumeStringProperty(json, "defaultContentType");
        node.setDefaultContentType(value);
        object2 = JsonUtil.consumeObjectProperty(json, "channels");
        if (object2 != null) {
            node.setChannels(node.createChannels());
            this.readChannels(object2, (AsyncApi20Channels)node.getChannels());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "components")) != null) {
            node.setComponents(node.createComponents());
            this.readComponents(object2, (AsyncApi20Components)node.getComponents());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "tags")) != null) {
            objects.forEach(object -> {
                AsyncApi20Tag model = node.createTag();
                this.readTag((ObjectNode)object, model);
                node.addTag(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "externalDocs")) != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, node.getExternalDocs());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    @Override
    public RootNode readRoot(ObjectNode json) {
        AsyncApi20DocumentImpl rootModel = new AsyncApi20DocumentImpl();
        this.readDocument(json, rootModel);
        return rootModel;
    }

    public void readInfo(ObjectNode json, AsyncApi20Info node) {
        String value = JsonUtil.consumeStringProperty(json, "title");
        node.setTitle(value);
        value = JsonUtil.consumeStringProperty(json, "version");
        node.setVersion(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "termsOfService");
        node.setTermsOfService(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "contact");
        if (object != null) {
            node.setContact(node.createContact());
            this.readContact(object, (AsyncApi20Contact)node.getContact());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "license")) != null) {
            node.setLicense(node.createLicense());
            this.readLicense(object, (AsyncApi20License)node.getLicense());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readContact(ObjectNode json, AsyncApi20Contact node) {
        String value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        value = JsonUtil.consumeStringProperty(json, "email");
        node.setEmail(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readLicense(ObjectNode json, AsyncApi20License node) {
        String value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readServers(ObjectNode json, AsyncApi20Servers node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                AsyncApi20Server model = (AsyncApi20Server)node.createServer();
                this.readServer(object, model);
                node.addItem((String)name, model);
            }
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readServer(ObjectNode json, AsyncApi20Server node) {
        String value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        value = JsonUtil.consumeStringProperty(json, "protocol");
        node.setProtocol(value);
        value = JsonUtil.consumeStringProperty(json, "protocolVersion");
        node.setProtocolVersion(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "variables");
        JsonUtil.keys(object2).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object2, name);
            if (mapValue != null) {
                AsyncApi20ServerVariable model = (AsyncApi20ServerVariable)node.createServerVariable();
                this.readServerVariable(mapValue, model);
                node.addVariable((String)name, model);
            }
        });
        List<ObjectNode> objects = JsonUtil.consumeObjectArrayProperty(json, "security");
        if (objects != null) {
            objects.forEach(object -> {
                AsyncApi20SecurityRequirement model = node.createSecurityRequirement();
                this.readSecurityRequirement((ObjectNode)object, model);
                node.addSecurity(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "bindings")) != null) {
            node.setBindings(node.createServerBindings());
            this.readServerBindings(object2, (AsyncApi20ServerBindings)node.getBindings());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readServerVariable(ObjectNode json, AsyncApi20ServerVariable node) {
        List<String> value = JsonUtil.consumeStringArrayProperty(json, "enum");
        node.setEnum(value);
        value = JsonUtil.consumeStringProperty(json, "default");
        node.setDefault((String)((Object)value));
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)((Object)value));
        value = JsonUtil.consumeStringArrayProperty(json, "examples");
        node.setExamples(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readChannels(ObjectNode json, AsyncApi20Channels node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                AsyncApi20ChannelItem model = node.createChannelItem();
                this.readChannelItem(object, model);
                node.addItem((String)name, model);
            }
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readChannelItem(ObjectNode json, AsyncApi20ChannelItem node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "subscribe");
        if (object != null) {
            node.setSubscribe(node.createOperation());
            this.readOperation(object, (AsyncApi20Operation)node.getSubscribe());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "publish")) != null) {
            node.setPublish(node.createOperation());
            this.readOperation(object, (AsyncApi20Operation)node.getPublish());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "parameters")) != null) {
            node.setParameters(node.createParameters());
            this.readParameters(object, (AsyncApi20Parameters)node.getParameters());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "bindings")) != null) {
            node.setBindings(node.createChannelBindings());
            this.readChannelBindings(object, (AsyncApi20ChannelBindings)node.getBindings());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOperation(ObjectNode json, AsyncApi20Operation node) {
        ObjectNode object2;
        String value = JsonUtil.consumeStringProperty(json, "operationId");
        node.setOperationId(value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        List<ObjectNode> objects = JsonUtil.consumeObjectArrayProperty(json, "tags");
        if (objects != null) {
            objects.forEach(object -> {
                AsyncApi20Tag model = (AsyncApi20Tag)node.createTag();
                this.readTag((ObjectNode)object, model);
                node.addTag(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "externalDocs")) != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, (AsyncApi20ExternalDocumentation)node.getExternalDocs());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "bindings")) != null) {
            node.setBindings(node.createOperationBindings());
            this.readOperationBindings(object2, (AsyncApi20OperationBindings)node.getBindings());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "traits")) != null) {
            objects.forEach(object -> {
                AsyncApi20OperationTrait model = (AsyncApi20OperationTrait)node.createOperationTrait();
                this.readOperationTrait((ObjectNode)object, model);
                node.addTrait(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "message")) != null) {
            node.setMessage(node.createMessage());
            this.readMessage(object2, node.getMessage());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOperationTrait(ObjectNode json, AsyncApi20OperationTrait node) {
        ObjectNode object2;
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "operationId");
        node.setOperationId(value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        List<ObjectNode> objects = JsonUtil.consumeObjectArrayProperty(json, "tags");
        if (objects != null) {
            objects.forEach(object -> {
                AsyncApi20Tag model = (AsyncApi20Tag)node.createTag();
                this.readTag((ObjectNode)object, model);
                node.addTag(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "externalDocs")) != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, (AsyncApi20ExternalDocumentation)node.getExternalDocs());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "bindings")) != null) {
            node.setBindings(node.createOperationBindings());
            this.readOperationBindings(object2, (AsyncApi20OperationBindings)node.getBindings());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readParameters(ObjectNode json, AsyncApi20Parameters node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            ObjectNode object = JsonUtil.consumeObjectProperty(json, name);
            if (object != null) {
                AsyncApi20Parameter model = (AsyncApi20Parameter)node.createParameter();
                this.readParameter(object, model);
                node.addItem((String)name, model);
            }
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readParameter(ObjectNode json, AsyncApi20Parameter node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "schema");
        if (object != null) {
            node.setSchema(node.createSchema());
            this.readSchema(object, node.getSchema());
        }
        value = JsonUtil.consumeStringProperty(json, "location");
        node.setLocation(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readServerBindings(ObjectNode json, AsyncApi20ServerBindings node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "http");
        if (object != null) {
            node.setHttp(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getHttp());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "ws")) != null) {
            node.setWs(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getWs());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "kafka")) != null) {
            node.setKafka(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getKafka());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "amqp")) != null) {
            node.setAmqp(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getAmqp());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "amqp1")) != null) {
            node.setAmqp1(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getAmqp1());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "mqtt")) != null) {
            node.setMqtt(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getMqtt());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "mqtt5")) != null) {
            node.setMqtt5(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getMqtt5());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "nats")) != null) {
            node.setNats(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getNats());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "jms")) != null) {
            node.setJms(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getJms());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "sns")) != null) {
            node.setSns(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getSns());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "sqs")) != null) {
            node.setSqs(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getSqs());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "stomp")) != null) {
            node.setStomp(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getStomp());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "redis")) != null) {
            node.setRedis(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getRedis());
        }
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readChannelBindings(ObjectNode json, AsyncApi20ChannelBindings node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "http");
        if (object != null) {
            node.setHttp(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getHttp());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "ws")) != null) {
            node.setWs(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getWs());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "kafka")) != null) {
            node.setKafka(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getKafka());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "amqp")) != null) {
            node.setAmqp(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getAmqp());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "amqp1")) != null) {
            node.setAmqp1(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getAmqp1());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "mqtt")) != null) {
            node.setMqtt(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getMqtt());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "mqtt5")) != null) {
            node.setMqtt5(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getMqtt5());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "nats")) != null) {
            node.setNats(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getNats());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "jms")) != null) {
            node.setJms(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getJms());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "sns")) != null) {
            node.setSns(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getSns());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "sqs")) != null) {
            node.setSqs(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getSqs());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "stomp")) != null) {
            node.setStomp(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getStomp());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "redis")) != null) {
            node.setRedis(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getRedis());
        }
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOperationBindings(ObjectNode json, AsyncApi20OperationBindings node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "http");
        if (object != null) {
            node.setHttp(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getHttp());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "ws")) != null) {
            node.setWs(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getWs());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "kafka")) != null) {
            node.setKafka(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getKafka());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "amqp")) != null) {
            node.setAmqp(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getAmqp());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "amqp1")) != null) {
            node.setAmqp1(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getAmqp1());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "mqtt")) != null) {
            node.setMqtt(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getMqtt());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "mqtt5")) != null) {
            node.setMqtt5(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getMqtt5());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "nats")) != null) {
            node.setNats(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getNats());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "jms")) != null) {
            node.setJms(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getJms());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "sns")) != null) {
            node.setSns(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getSns());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "sqs")) != null) {
            node.setSqs(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getSqs());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "stomp")) != null) {
            node.setStomp(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getStomp());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "redis")) != null) {
            node.setRedis(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getRedis());
        }
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readMessageBindings(ObjectNode json, AsyncApi20MessageBindings node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "http");
        if (object != null) {
            node.setHttp(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getHttp());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "ws")) != null) {
            node.setWs(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getWs());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "kafka")) != null) {
            node.setKafka(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getKafka());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "amqp")) != null) {
            node.setAmqp(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getAmqp());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "amqp1")) != null) {
            node.setAmqp1(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getAmqp1());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "mqtt")) != null) {
            node.setMqtt(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getMqtt());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "mqtt5")) != null) {
            node.setMqtt5(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getMqtt5());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "nats")) != null) {
            node.setNats(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getNats());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "jms")) != null) {
            node.setJms(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getJms());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "sns")) != null) {
            node.setSns(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getSns());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "sqs")) != null) {
            node.setSqs(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getSqs());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "stomp")) != null) {
            node.setStomp(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getStomp());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "redis")) != null) {
            node.setRedis(node.createBinding());
            this.readBinding(object, (AsyncApi20Binding)node.getRedis());
        }
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOneOfMessages(ObjectNode json, AsyncApi20OneOfMessages node) {
        List<ObjectNode> objects = JsonUtil.consumeObjectArrayProperty(json, "oneOf");
        if (objects != null) {
            objects.forEach(object -> {
                AsyncApi20Message model = (AsyncApi20Message)node.createMessage();
                this.readMessage((ObjectNode)object, model);
                node.addOneOf(model);
            });
        }
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readMessage(ObjectNode json, AsyncApi20Message node) {
        ObjectNode object2;
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        List<ObjectNode> objects = JsonUtil.consumeObjectArrayProperty(json, "oneOf");
        if (objects != null) {
            objects.forEach(object -> {
                AsyncApi20Message model = node.createMessage();
                this.readMessage((ObjectNode)object, model);
                node.addOneOf(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "headers")) != null) {
            node.setHeaders(node.createSchema());
            this.readSchema(object2, node.getHeaders());
        }
        value = JsonUtil.consumeAnyProperty(json, "payload");
        node.setPayload((JsonNode)value);
        object2 = JsonUtil.consumeObjectProperty(json, "correlationId");
        if (object2 != null) {
            node.setCorrelationId(node.createCorrelationID());
            this.readCorrelationID(object2, (AsyncApi20CorrelationID)node.getCorrelationId());
        }
        value = JsonUtil.consumeStringProperty(json, "schemaFormat");
        node.setSchemaFormat((String)value);
        value = JsonUtil.consumeStringProperty(json, "contentType");
        node.setContentType((String)value);
        value = JsonUtil.consumeStringProperty(json, "name");
        node.setName((String)value);
        value = JsonUtil.consumeStringProperty(json, "title");
        node.setTitle((String)value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        objects = JsonUtil.consumeObjectArrayProperty(json, "tags");
        if (objects != null) {
            objects.forEach(object -> {
                AsyncApi20Tag model = (AsyncApi20Tag)node.createTag();
                this.readTag((ObjectNode)object, model);
                node.addTag(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "externalDocs")) != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, (AsyncApi20ExternalDocumentation)node.getExternalDocs());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "bindings")) != null) {
            node.setBindings(node.createMessageBindings());
            this.readMessageBindings(object2, (AsyncApi20MessageBindings)node.getBindings());
        }
        value = JsonUtil.consumeAnyMapProperty(json, "examples");
        node.setExamples((Map<String, JsonNode>)value);
        objects = JsonUtil.consumeObjectArrayProperty(json, "traits");
        if (objects != null) {
            objects.forEach(object -> {
                AsyncApi20MessageTrait model = (AsyncApi20MessageTrait)node.createMessageTrait();
                this.readMessageTrait((ObjectNode)object, model);
                node.addTrait(model);
            });
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readMessageTrait(ObjectNode json, AsyncApi20MessageTrait node) {
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        ObjectNode object2 = JsonUtil.consumeObjectProperty(json, "headers");
        if (object2 != null) {
            node.setHeaders(node.createSchema());
            this.readSchema(object2, node.getHeaders());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "correlationId")) != null) {
            node.setCorrelationId(node.createCorrelationID());
            this.readCorrelationID(object2, (AsyncApi20CorrelationID)node.getCorrelationId());
        }
        value = JsonUtil.consumeStringProperty(json, "schemaFormat");
        node.setSchemaFormat((String)value);
        value = JsonUtil.consumeStringProperty(json, "contentType");
        node.setContentType((String)value);
        value = JsonUtil.consumeStringProperty(json, "name");
        node.setName((String)value);
        value = JsonUtil.consumeStringProperty(json, "title");
        node.setTitle((String)value);
        value = JsonUtil.consumeStringProperty(json, "summary");
        node.setSummary((String)value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        List<ObjectNode> objects = JsonUtil.consumeObjectArrayProperty(json, "tags");
        if (objects != null) {
            objects.forEach(object -> {
                AsyncApi20Tag model = (AsyncApi20Tag)node.createTag();
                this.readTag((ObjectNode)object, model);
                node.addTag(model);
            });
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "externalDocs")) != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object2, (AsyncApi20ExternalDocumentation)node.getExternalDocs());
        }
        if ((object2 = JsonUtil.consumeObjectProperty(json, "bindings")) != null) {
            node.setBindings(node.createMessageBindings());
            this.readMessageBindings(object2, (AsyncApi20MessageBindings)node.getBindings());
        }
        value = JsonUtil.consumeAnyMapProperty(json, "examples");
        node.setExamples((Map<String, JsonNode>)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readTag(ObjectNode json, AsyncApi20Tag node) {
        String value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "externalDocs");
        if (object != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object, (AsyncApi20ExternalDocumentation)node.getExternalDocs());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readExternalDocumentation(ObjectNode json, AsyncApi20ExternalDocumentation node) {
        String value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "url");
        node.setUrl(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readComponents(ObjectNode json, AsyncApi20Components node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "schemas");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                AsyncApi20Schema model = (AsyncApi20Schema)node.createSchema();
                this.readSchema(mapValue, model);
                node.addSchema((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "messages");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                AsyncApi20Message model = (AsyncApi20Message)node.createMessage();
                this.readMessage(mapValue, model);
                node.addMessage((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "securitySchemes");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                AsyncApi20SecurityScheme model = (AsyncApi20SecurityScheme)node.createSecurityScheme();
                this.readSecurityScheme(mapValue, model);
                node.addSecurityScheme((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "parameters");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                AsyncApi20Parameter model = (AsyncApi20Parameter)node.createParameter();
                this.readParameter(mapValue, model);
                node.addParameter((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "correlationIds");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                AsyncApi20CorrelationID model = (AsyncApi20CorrelationID)node.createCorrelationID();
                this.readCorrelationID(mapValue, model);
                node.addCorrelationId((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "operationTraits");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                AsyncApi20OperationTrait model = (AsyncApi20OperationTrait)node.createOperationTrait();
                this.readOperationTrait(mapValue, model);
                node.addOperationTrait((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "messageTraits");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                AsyncApi20MessageTrait model = (AsyncApi20MessageTrait)node.createMessageTrait();
                this.readMessageTrait(mapValue, model);
                node.addMessageTrait((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "serverBindings");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                AsyncApi20ServerBindings model = (AsyncApi20ServerBindings)node.createServerBindings();
                this.readServerBindings(mapValue, model);
                node.addServerBinding((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "channelBindings");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                AsyncApi20ChannelBindings model = (AsyncApi20ChannelBindings)node.createChannelBindings();
                this.readChannelBindings(mapValue, model);
                node.addChannelBinding((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "operationBindings");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                AsyncApi20OperationBindings model = (AsyncApi20OperationBindings)node.createOperationBindings();
                this.readOperationBindings(mapValue, model);
                node.addOperationBinding((String)name, model);
            }
        });
        object = JsonUtil.consumeObjectProperty(json, "messageBindings");
        JsonUtil.keys(object).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object, name);
            if (mapValue != null) {
                AsyncApi20MessageBindings model = (AsyncApi20MessageBindings)node.createMessageBindings();
                this.readMessageBindings(mapValue, model);
                node.addMessageBinding((String)name, model);
            }
        });
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSchema(ObjectNode json, AsyncApi20Schema node) {
        List<ObjectNode> objects;
        ObjectNode object2;
        Object value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref((String)value);
        value = JsonUtil.consumeStringProperty(json, "title");
        node.setTitle((String)value);
        value = JsonUtil.consumeStringProperty(json, "type");
        node.setType((String)value);
        value = JsonUtil.consumeStringArrayProperty(json, "required");
        node.setRequired((List<String>)value);
        value = JsonUtil.consumeNumberProperty(json, "multipleOf");
        node.setMultipleOf((Number)value);
        value = JsonUtil.consumeNumberProperty(json, "maximum");
        node.setMaximum((Number)value);
        value = JsonUtil.consumeNumberProperty(json, "exclusiveMaximum");
        node.setExclusiveMaximum((Number)value);
        value = JsonUtil.consumeNumberProperty(json, "minimum");
        node.setMinimum((Number)value);
        value = JsonUtil.consumeNumberProperty(json, "exclusiveMinimum");
        node.setExclusiveMinimum((Number)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxLength");
        node.setMaxLength((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minLength");
        node.setMinLength((Integer)value);
        value = JsonUtil.consumeStringProperty(json, "pattern");
        node.setPattern((String)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxItems");
        node.setMaxItems((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minItems");
        node.setMinItems((Integer)value);
        value = JsonUtil.consumeBooleanProperty(json, "uniqueItems");
        node.setUniqueItems((Boolean)value);
        value = JsonUtil.consumeIntegerProperty(json, "maxProperties");
        node.setMaxProperties((Integer)value);
        value = JsonUtil.consumeIntegerProperty(json, "minProperties");
        node.setMinProperties((Integer)value);
        value = JsonUtil.consumeAnyArrayProperty(json, "enum");
        node.setEnum((List<JsonNode>)value);
        value = JsonUtil.consumeAnyProperty(json, "const");
        node.setConst((JsonNode)value);
        value = JsonUtil.consumeAnyArrayProperty(json, "examples");
        node.setExamples((List<JsonNode>)value);
        ObjectNode object3 = JsonUtil.consumeObjectProperty(json, "if");
        if (object3 != null) {
            node.setIf(node.createSchema());
            this.readSchema(object3, (AsyncApi20Schema)node.getIf());
        }
        if ((object3 = JsonUtil.consumeObjectProperty(json, "then")) != null) {
            node.setThen(node.createSchema());
            this.readSchema(object3, (AsyncApi20Schema)node.getThen());
        }
        if ((object3 = JsonUtil.consumeObjectProperty(json, "else")) != null) {
            node.setElse(node.createSchema());
            this.readSchema(object3, (AsyncApi20Schema)node.getElse());
        }
        value = JsonUtil.consumeBooleanProperty(json, "readOnly");
        node.setReadOnly((Boolean)value);
        value = JsonUtil.consumeBooleanProperty(json, "writeOnly");
        node.setWriteOnly((Boolean)value);
        object3 = JsonUtil.consumeObjectProperty(json, "properties");
        JsonUtil.keys(object3).forEach(name -> {
            ObjectNode mapValue = JsonUtil.consumeObjectProperty(object3, name);
            if (mapValue != null) {
                AsyncApi20Schema model = (AsyncApi20Schema)node.createSchema();
                this.readSchema(mapValue, model);
                node.addProperty((String)name, model);
            }
        });
        value = JsonUtil.consumeStringMapProperty(json, "patternProperties");
        node.setPatternProperties((Map<String, String>)value);
        value = JsonUtil.consumeAnyProperty(json, "additionalProperties");
        if (value != null) {
            if (JsonUtil.isObject(value)) {
                object2 = JsonUtil.toObject(value);
                node.setAdditionalProperties(node.createSchema());
                this.readSchema(object2, (AsyncApi20Schema)node.getAdditionalProperties());
            } else if (JsonUtil.isBoolean(value)) {
                Boolean pValue = JsonUtil.toBoolean(value);
                BooleanUnionValueImpl unionValue = new BooleanUnionValueImpl(pValue);
                node.setAdditionalProperties(unionValue);
            } else {
                node.addExtraProperty("additionalProperties", (JsonNode)value);
            }
        }
        if ((object3 = JsonUtil.consumeObjectProperty(json, "additionalItems")) != null) {
            node.setAdditionalItems(node.createSchema());
            this.readSchema(object3, (AsyncApi20Schema)node.getAdditionalItems());
        }
        if ((value = JsonUtil.consumeAnyProperty(json, "items")) != null) {
            if (JsonUtil.isObject(value)) {
                object2 = JsonUtil.toObject(value);
                node.setItems(node.createSchema());
                this.readSchema(object2, (AsyncApi20Schema)node.getItems());
            } else if (JsonUtil.isArray(value)) {
                List<JsonNode> array = JsonUtil.toList(value);
                ArrayList<Schema> models = new ArrayList<Schema>();
                array.forEach(item -> {
                    ObjectNode object = JsonUtil.toObject(item);
                    AsyncApi20Schema model = (AsyncApi20Schema)node.createSchema();
                    this.readSchema(object, model);
                    models.add(model);
                });
                SchemaListUnionValueImpl unionValue = new SchemaListUnionValueImpl((List<Schema>)models);
                node.setItems(unionValue);
            } else {
                node.addExtraProperty("items", (JsonNode)value);
            }
        }
        if ((object3 = JsonUtil.consumeObjectProperty(json, "propertyNames")) != null) {
            node.setPropertyNames(node.createSchema());
            this.readSchema(object3, (AsyncApi20Schema)node.getPropertyNames());
        }
        if ((object3 = JsonUtil.consumeObjectProperty(json, "contains")) != null) {
            node.setContains(node.createSchema());
            this.readSchema(object3, (AsyncApi20Schema)node.getContains());
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "allOf")) != null) {
            objects.forEach(object -> {
                AsyncApi20Schema model = (AsyncApi20Schema)node.createSchema();
                this.readSchema((ObjectNode)object, model);
                node.addAllOf(model);
            });
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "oneOf")) != null) {
            objects.forEach(object -> {
                AsyncApi20Schema model = (AsyncApi20Schema)node.createSchema();
                this.readSchema((ObjectNode)object, model);
                node.addOneOf(model);
            });
        }
        if ((objects = JsonUtil.consumeObjectArrayProperty(json, "anyOf")) != null) {
            objects.forEach(object -> {
                AsyncApi20Schema model = (AsyncApi20Schema)node.createSchema();
                this.readSchema((ObjectNode)object, model);
                node.addAnyOf(model);
            });
        }
        if ((object3 = JsonUtil.consumeObjectProperty(json, "not")) != null) {
            node.setNot(node.createSchema());
            this.readSchema(object3, (AsyncApi20Schema)node.getNot());
        }
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription((String)value);
        value = JsonUtil.consumeStringProperty(json, "format");
        node.setFormat((String)value);
        value = JsonUtil.consumeAnyProperty(json, "default");
        node.setDefault((JsonNode)value);
        value = JsonUtil.consumeStringProperty(json, "discriminator");
        node.setDiscriminator((String)value);
        object3 = JsonUtil.consumeObjectProperty(json, "externalDocs");
        if (object3 != null) {
            node.setExternalDocs(node.createExternalDocumentation());
            this.readExternalDocumentation(object3, (AsyncApi20ExternalDocumentation)node.getExternalDocs());
        }
        value = JsonUtil.consumeBooleanProperty(json, "deprecated");
        node.setDeprecated((Boolean)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSecurityScheme(ObjectNode json, AsyncApi20SecurityScheme node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "type");
        node.setType(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "name");
        node.setName(value);
        value = JsonUtil.consumeStringProperty(json, "in");
        node.setIn(value);
        value = JsonUtil.consumeStringProperty(json, "scheme");
        node.setScheme(value);
        value = JsonUtil.consumeStringProperty(json, "bearerFormat");
        node.setBearerFormat(value);
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "flows");
        if (object != null) {
            node.setFlows(node.createOAuthFlows());
            this.readOAuthFlows(object, (AsyncApi20OAuthFlows)node.getFlows());
        }
        value = JsonUtil.consumeStringProperty(json, "openIdConnectUrl");
        node.setOpenIdConnectUrl(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOAuthFlows(ObjectNode json, AsyncApi20OAuthFlows node) {
        ObjectNode object = JsonUtil.consumeObjectProperty(json, "implicit");
        if (object != null) {
            node.setImplicit(node.createOAuthFlow());
            this.readOAuthFlow(object, (AsyncApi20OAuthFlow)node.getImplicit());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "password")) != null) {
            node.setPassword(node.createOAuthFlow());
            this.readOAuthFlow(object, (AsyncApi20OAuthFlow)node.getPassword());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "clientCredentials")) != null) {
            node.setClientCredentials(node.createOAuthFlow());
            this.readOAuthFlow(object, (AsyncApi20OAuthFlow)node.getClientCredentials());
        }
        if ((object = JsonUtil.consumeObjectProperty(json, "authorizationCode")) != null) {
            node.setAuthorizationCode(node.createOAuthFlow());
            this.readOAuthFlow(object, (AsyncApi20OAuthFlow)node.getAuthorizationCode());
        }
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readOAuthFlow(ObjectNode json, AsyncApi20OAuthFlow node) {
        Object value = JsonUtil.consumeStringProperty(json, "authorizationUrl");
        node.setAuthorizationUrl((String)value);
        value = JsonUtil.consumeStringProperty(json, "tokenUrl");
        node.setTokenUrl((String)value);
        value = JsonUtil.consumeStringProperty(json, "refreshUrl");
        node.setRefreshUrl((String)value);
        value = JsonUtil.consumeStringMapProperty(json, "scopes");
        node.setScopes((Map<String, String>)value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readSecurityRequirement(ObjectNode json, AsyncApi20SecurityRequirement node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            List<String> value = JsonUtil.consumeStringArrayProperty(json, name);
            node.addItem((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readCorrelationID(ObjectNode json, AsyncApi20CorrelationID node) {
        String value = JsonUtil.consumeStringProperty(json, "$ref");
        node.set$ref(value);
        value = JsonUtil.consumeStringProperty(json, "description");
        node.setDescription(value);
        value = JsonUtil.consumeStringProperty(json, "location");
        node.setLocation(value);
        List<String> propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }

    public void readBinding(ObjectNode json, AsyncApi20Binding node) {
        List<String> propertyNames = JsonUtil.keys(json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addItem((String)name, value);
        });
        propertyNames = JsonUtil.matchingKeys("^x-.+$", json);
        propertyNames.forEach(name -> {
            JsonNode value = JsonUtil.consumeAnyProperty(json, name);
            node.addExtension((String)name, value);
        });
        ReaderUtil.readExtraProperties(json, node);
    }
}

