/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.paths;

import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.union.ListUnionValue;
import io.apicurio.datamodels.models.visitors.AllNodeVisitor;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathSegment;
import io.apicurio.datamodels.util.NodeUtil;
import java.util.List;

public class NodePathCreationVisitor
extends AllNodeVisitor {
    protected NodePath path = new NodePath();

    @Override
    public void visitDocument(Document node) {
    }

    @Override
    protected void visitNode(Node node) {
        switch (node.parentPropertyType()) {
            case standard: {
                this.path.prepend(new NodePathSegment(node.parentPropertyName(), false));
                return;
            }
            case map: {
                this.path.prepend(new NodePathSegment(node.mapPropertyName(), true));
                if (node.parentPropertyName() != null) {
                    this.path.prepend(new NodePathSegment(node.parentPropertyName(), false));
                }
                return;
            }
            case array: {
                Object parentPropertyValue = NodeUtil.getNodeProperty(node.parent(), node.parentPropertyName());
                if (parentPropertyValue == null) break;
                if (parentPropertyValue instanceof List) {
                    List nodes = (List)parentPropertyValue;
                    int idx = nodes.indexOf(node);
                    this.path.prepend(new NodePathSegment("" + idx, true));
                    this.path.prepend(new NodePathSegment(node.parentPropertyName(), false));
                    break;
                }
                if (!(parentPropertyValue instanceof ListUnionValue)) break;
                List nodes = (List)((ListUnionValue)parentPropertyValue).getValue();
                int idx = nodes.indexOf(node);
                this.path.prepend(new NodePathSegment("" + idx, true));
                this.path.prepend(new NodePathSegment(node.parentPropertyName(), false));
            }
        }
    }
}

