/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.refs;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.apicurio.datamodels.refs.ReferenceResolverChain;
import io.apicurio.datamodels.refs.ResolverOptions;
import io.apicurio.datamodels.refs.ResolverOptionsType;
import io.apicurio.datamodels.util.NodeUtil;
import io.apicurio.datamodels.util.RegexUtil;
import java.util.HashSet;
import java.util.List;

public class ReferenceUtil {
    public static Node resolveNodeRef(Node node) {
        return ReferenceUtil.resolveNodeRefWithOptions(node, ResolverOptions.of(ResolverOptionsType.RECURSIVE));
    }

    public static Node resolveNodeRefWithOptions(Node node, ResolverOptions options) {
        if (!ReferenceUtil.hasValue(node)) {
            return null;
        }
        String $ref = (String)NodeUtil.getProperty(node, "$ref");
        return ReferenceUtil.resolveRefWithOptions($ref, node, options);
    }

    public static Node resolveRef(String $ref, Node from) {
        if (!ReferenceUtil.hasValue($ref)) {
            return null;
        }
        return ReferenceUtil.resolveRefWithOptions($ref, from, ResolverOptions.of(ResolverOptionsType.RECURSIVE, ResolverOptionsType.NULL_IF_NOT_FOUND));
    }

    public static Node resolveRefWithOptions(String $ref, Node from, ResolverOptions options) {
        ReferenceResolverChain resolver = ReferenceResolverChain.getInstance();
        Node rval = null;
        if (ReferenceUtil.hasValue($ref)) {
            rval = resolver.resolveRef($ref, from);
        }
        if (rval != null && options.contains(ResolverOptionsType.RECURSIVE)) {
            HashSet<String> observedRefs = new HashSet<String>();
            boolean done = false;
            while (!done) {
                observedRefs.add($ref);
                $ref = (String)NodeUtil.getProperty(rval, "$ref");
                if (ReferenceUtil.hasValue($ref) && !observedRefs.contains($ref)) {
                    rval = resolver.resolveRef($ref, from);
                } else if (observedRefs.contains($ref)) {
                    rval = null;
                    done = true;
                } else {
                    done = true;
                }
                if (ReferenceUtil.hasValue(rval)) continue;
                done = true;
            }
        }
        if (rval != null) {
            return rval;
        }
        if (options.contains(ResolverOptionsType.NULL_IF_NOT_FOUND)) {
            return null;
        }
        return from;
    }

    public static boolean canResolveRef(String $ref, Node from) {
        return ReferenceUtil.hasValue(ReferenceUtil.resolveRef($ref, from));
    }

    public static boolean hasValue(Object value) {
        return !NodeUtil.isNullOrUndefined(value);
    }

    public static ObjectNode resolveFragmentFromJS(ObjectNode contextNode, String fragment) {
        List<String[]> split = RegexUtil.findMatches(fragment, "([^/]+)/?");
        ObjectNode cnode = contextNode;
        for (String[] mi : split) {
            String seg = mi[1];
            if (NodeUtil.equals(seg, "#")) {
                cnode = contextNode;
                continue;
            }
            if (cnode == null) continue;
            cnode = (ObjectNode)JsonUtil.getProperty(cnode, seg);
        }
        return cnode;
    }
}

