/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.transform;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Document;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Schema;
import io.apicurio.datamodels.models.openapi.v30.visitors.OpenApi30Visitor;
import io.apicurio.datamodels.models.openapi.v30.visitors.OpenApi30VisitorAdapter;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Document;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Schema;
import io.apicurio.datamodels.models.union.StringListUnionValueImpl;
import io.apicurio.datamodels.models.union.StringUnionValueImpl;
import io.apicurio.datamodels.paths.NodePathUtil;
import java.util.List;

public class OpenApi30to31TransformationVisitor
extends OpenApi30VisitorAdapter
implements OpenApi30Visitor {
    private OpenApi31Document doc31;

    public OpenApi30to31TransformationVisitor(OpenApi30Document source) {
        this.doc31 = (OpenApi31Document)Library.cloneDocument(source, rawJson -> {
            rawJson.put("openapi", "3.1.0");
            return rawJson;
        });
    }

    public OpenApi31Document getResult() {
        return this.doc31;
    }

    @Override
    public void visitSchema(Schema node) {
        this.mapSchema((OpenApi30Schema)node, this.findMatchingNode(node));
    }

    private OpenApi31Schema findMatchingNode(Node node) {
        return (OpenApi31Schema)NodePathUtil.resolveNodePath(NodePathUtil.createNodePath(node), this.doc31);
    }

    private void mapSchema(OpenApi30Schema from, OpenApi31Schema schema31) {
        schema31.getExtraPropertyNames().forEach(schema31::removeExtraProperty);
        if (from.getType() == null) {
            schema31.setType(new StringUnionValueImpl(from.getType()));
        } else if (Boolean.TRUE.equals(from.isNullable())) {
            schema31.setType(new StringListUnionValueImpl(List.of(from.getType(), "null")));
        } else {
            schema31.setType(new StringUnionValueImpl(from.getType()));
        }
        if (Boolean.TRUE.equals(from.isExclusiveMaximum())) {
            schema31.setExclusiveMaximum(from.getMaximum());
            schema31.setMaximum(null);
        } else {
            schema31.setMaximum(from.getMaximum());
        }
        if (Boolean.TRUE.equals(from.isExclusiveMinimum())) {
            schema31.setExclusiveMinimum(from.getMinimum());
            schema31.setMinimum(null);
        } else {
            schema31.setMinimum(from.getMinimum());
        }
    }
}

