/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.format;

import io.apicurio.datamodels.models.Server;
import io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Server;
import io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Server;
import io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Server;
import io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Server;
import io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Server;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Server;
import io.apicurio.datamodels.models.asyncapi.v26.AsyncApi26Server;
import io.apicurio.datamodels.models.openapi.OpenApiServer;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;

public class InvalidServerUrlRule
extends ValidationRule {
    public InvalidServerUrlRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitServer(Server node) {
        String url = this.getUrl(node);
        if (this.hasValue(url)) {
            this.reportIfInvalid(this.isValidUrlTemplate(url), node, "url", this.map(new String[0]));
        }
    }

    private String getUrl(Server node) {
        if (ModelTypeUtil.isOpenApiModel(node)) {
            return ((OpenApiServer)node).getUrl();
        }
        if (ModelTypeUtil.isAsyncApi2Model(node)) {
            if (node instanceof AsyncApi20Server) {
                return ((AsyncApi20Server)node).getUrl();
            }
            if (node instanceof AsyncApi21Server) {
                return ((AsyncApi21Server)node).getUrl();
            }
            if (node instanceof AsyncApi22Server) {
                return ((AsyncApi22Server)node).getUrl();
            }
            if (node instanceof AsyncApi23Server) {
                return ((AsyncApi23Server)node).getUrl();
            }
            if (node instanceof AsyncApi24Server) {
                return ((AsyncApi24Server)node).getUrl();
            }
            if (node instanceof AsyncApi25Server) {
                return ((AsyncApi25Server)node).getUrl();
            }
            if (node instanceof AsyncApi26Server) {
                return ((AsyncApi26Server)node).getUrl();
            }
        }
        return null;
    }
}

