/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Parameter;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Parameter;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;

public class OasAllowReservedNotAllowedForParamRule
extends AbstractInvalidPropertyValueRule {
    public OasAllowReservedNotAllowedForParamRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitParameter(Parameter node) {
        OpenApiParameter param = (OpenApiParameter)node;
        Boolean isAllowReserved = null;
        if (ModelTypeUtil.isOpenApi30Model(node)) {
            isAllowReserved = ((OpenApi30Parameter)node).isAllowReserved();
        } else if (ModelTypeUtil.isOpenApi31Model(node)) {
            isAllowReserved = ((OpenApi31Parameter)node).isAllowReserved();
        }
        if (this.hasValue(isAllowReserved)) {
            this.reportIfInvalid(this.equals(param.getIn(), "query"), node, "allowReserved", this.map(new String[0]));
        }
    }
}

