/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.openapi.OpenApiHeader;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Header;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Header;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;

public class OasInvalidHeaderStyleRule
extends AbstractInvalidPropertyValueRule {
    public OasInvalidHeaderStyleRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitHeader(OpenApiHeader node) {
        String style = null;
        if (ModelTypeUtil.isOpenApi30Model(node)) {
            style = ((OpenApi30Header)node).getStyle();
        } else if (ModelTypeUtil.isOpenApi31Model(node)) {
            style = ((OpenApi31Header)node).getStyle();
        }
        if (this.hasValue(style)) {
            this.reportIfInvalid(this.isValidEnumItem(style, this.array("simple")), node, "style", this.map(new String[0]));
        }
    }
}

