/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.Operation;
import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;
import java.util.ArrayList;
import java.util.List;

public class OasMissingPathParamDefinitionRule
extends AbstractInvalidPropertyValueRule {
    private List<String> pathItemsWithError = new ArrayList<String>();
    private String pathItemTemplate;

    public OasMissingPathParamDefinitionRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private boolean hasPathParameter(String paramName, List<OpenApiParameter> parameters) {
        for (OpenApiParameter parameter : parameters) {
            if (!this.equals(parameter.getIn(), "path") || !this.equals(parameter.getName(), paramName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitPathItem(OpenApiPathItem node) {
        this.pathItemTemplate = this.getPathTemplate(node);
        if (!this.isPathWellFormed(this.pathItemTemplate)) {
            this.pathItemsWithError.add(this.pathItemTemplate);
        }
    }

    @Override
    public void visitOperation(Operation node) {
        String method = this.getOperationMethod(node);
        if (this.pathItemsWithError.indexOf(this.pathItemTemplate) != -1) {
            return;
        }
        List<OpenApiParameter> mergedParameters = this.mergeParameters((OpenApiOperation)node);
        List<ValidationRule.PathSegment> pathSegs = this.getPathSegments(this.pathItemTemplate);
        for (ValidationRule.PathSegment pathSeg : pathSegs) {
            if (!this.hasValue(pathSeg.formalName)) continue;
            boolean valid = this.hasPathParameter(pathSeg.formalName, mergedParameters);
            this.reportIfInvalid(valid, node, null, this.map("param", pathSeg.formalName, "path", this.pathItemTemplate, "method", method.toUpperCase()));
        }
    }
}

