/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.openapi.OpenApiExamplesParent;
import io.apicurio.datamodels.models.openapi.OpenApiHeader;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Header;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Header;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;
import java.util.Map;

public class OasUnexpectedNumberOfHeaderMTsRule
extends AbstractInvalidPropertyValueRule {
    public OasUnexpectedNumberOfHeaderMTsRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitHeader(OpenApiHeader node) {
        Map<String, OpenApiExamplesParent> content = null;
        if (ModelTypeUtil.isOpenApi30Model(node)) {
            content = ((OpenApi30Header)node).getContent();
        } else if (ModelTypeUtil.isOpenApi31Model(node)) {
            content = ((OpenApi31Header)node).getContent();
        }
        if (this.isDefined(content)) {
            this.reportIfInvalid(content.size() < 2, node, "content", this.map(new String[0]));
        }
    }
}

