/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Parameter;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Parameter;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;

public class OasUnknownParamStyleRule
extends AbstractInvalidPropertyValueRule {
    public OasUnknownParamStyleRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitParameter(Parameter node) {
        String style = null;
        if (ModelTypeUtil.isOpenApi30Model(node)) {
            style = ((OpenApi30Parameter)node).getStyle();
        } else if (ModelTypeUtil.isOpenApi31Model(node)) {
            style = ((OpenApi31Parameter)node).getStyle();
        }
        if (this.hasValue(style)) {
            this.reportIfInvalid(this.isValidEnumItem(style, this.array("matrix", "label", "form", "simple", "spaceDelimited", "pipeDelimited", "deepObject")), node, "style", this.map("style", style));
        }
    }
}

