/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Parameter;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Parameter;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;

public class OasUnknownPathParamStyleRule
extends AbstractInvalidPropertyValueRule {
    public OasUnknownPathParamStyleRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitParameter(Parameter node) {
        String style = null;
        String in = null;
        if (ModelTypeUtil.isOpenApi30Model(node)) {
            style = ((OpenApi30Parameter)node).getStyle();
            in = ((OpenApi30Parameter)node).getIn();
        } else if (ModelTypeUtil.isOpenApi31Model(node)) {
            style = ((OpenApi31Parameter)node).getStyle();
            in = ((OpenApi31Parameter)node).getIn();
        }
        if (this.equals(in, "path") && this.hasValue(style)) {
            this.reportIfInvalid(this.isValidEnumItem(style, this.array("matrix", "label", "simple")), node, "style", this.map("style", style));
        }
    }
}

