/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.mutex;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Operation;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.models.openapi.OpenApiParametersParent;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import java.util.List;

public class OasBodyAndFormDataMutualExclusivityRule
extends ValidationRule {
    public OasBodyAndFormDataMutualExclusivityRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private void visitParameterParent(OpenApiParametersParent paramParent) {
        List<OpenApiParameter> parameters = paramParent.getParameters();
        if (this.hasValue(parameters)) {
            boolean hasBodyParam = false;
            boolean hasFormDataParam = false;
            for (OpenApiParameter param : parameters) {
                if (this.equals(param.getIn(), "body")) {
                    hasBodyParam = true;
                }
                if (!this.equals(param.getIn(), "formData")) continue;
                hasFormDataParam = true;
            }
            this.reportIf(hasBodyParam && hasFormDataParam, (Node)((Object)paramParent), "in", this.map(new String[0]));
        }
    }

    @Override
    public void visitOperation(Operation node) {
        this.visitParameterParent((OpenApiParametersParent)((Object)node));
    }

    @Override
    public void visitPathItem(OpenApiPathItem node) {
        this.visitParameterParent((OpenApiParametersParent)((Object)node));
    }
}

