/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.mutex;

import io.apicurio.datamodels.models.openapi.OpenApiExamplesParent;
import io.apicurio.datamodels.models.openapi.OpenApiHeader;
import io.apicurio.datamodels.models.openapi.OpenApiReferenceable;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Header;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Header;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import java.util.Map;

public class OasHeaderSchemaContentMutualExclusivityRule
extends ValidationRule {
    public OasHeaderSchemaContentMutualExclusivityRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private boolean hasContent(Map<String, ?> content) {
        return this.isDefined(content) && !content.isEmpty();
    }

    @Override
    public void visitHeader(OpenApiHeader node) {
        OpenApiReferenceable schema = null;
        Map<String, OpenApiExamplesParent> content = null;
        if (ModelTypeUtil.isOpenApi30Model(node)) {
            schema = ((OpenApi30Header)node).getSchema();
            content = ((OpenApi30Header)node).getContent();
        } else if (ModelTypeUtil.isOpenApi31Model(node)) {
            schema = ((OpenApi31Header)node).getSchema();
            content = ((OpenApi31Header)node).getContent();
        }
        this.reportIf(this.hasValue(schema) && this.hasContent(content), node, "schema", this.map(new String[0]));
    }
}

