/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.mutex;

import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.openapi.OpenApiExamplesParent;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Parameter;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Parameter;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import java.util.Map;

public class OasParameterSchemaContentMutualExclusivityRule
extends ValidationRule {
    public OasParameterSchemaContentMutualExclusivityRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private boolean hasContent(OpenApiParameter contentParent) {
        Map<String, OpenApiExamplesParent> content = null;
        if (ModelTypeUtil.isOpenApi30Model(contentParent)) {
            content = ((OpenApi30Parameter)contentParent).getContent();
        } else if (ModelTypeUtil.isOpenApi31Model(contentParent)) {
            content = ((OpenApi31Parameter)contentParent).getContent();
        }
        if (!this.isDefined(content)) {
            return false;
        }
        return !content.isEmpty();
    }

    @Override
    public void visitParameter(Parameter node) {
        OpenApiParameter parameter = (OpenApiParameter)node;
        this.reportIf(this.hasValue(parameter.getSchema()) && this.hasContent(parameter), node, "schema", this.map(new String[0]));
    }
}

