/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.other;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Operation;
import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.models.openapi.OpenApiParametersParent;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import io.apicurio.datamodels.refs.ReferenceUtil;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import java.util.ArrayList;
import java.util.List;

public class OasParameterUniquenessValidationRule
extends ValidationRule {
    public OasParameterUniquenessValidationRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private int getParamCount(List<OpenApiParameter> params, String paramName, String paramIn) {
        int count = 0;
        for (OpenApiParameter param : params) {
            if (!this.hasValue(param) || !this.equals(param.getName(), paramName) || !this.equals(param.getIn(), paramIn)) continue;
            ++count;
        }
        return count;
    }

    private void ensureUnique(OpenApiParametersParent paramsParent) {
        List<OpenApiParameter> params = paramsParent.getParameters();
        if (!this.hasValue(params)) {
            return;
        }
        ArrayList<OpenApiParameter> resolvedParams = new ArrayList<OpenApiParameter>(params.size());
        params.forEach(param -> {
            Node resolveNodeRef = ReferenceUtil.resolveNodeRef(param);
            if (resolveNodeRef instanceof OpenApiParameter) {
                resolvedParams.add((OpenApiParameter)resolveNodeRef);
            } else {
                resolvedParams.add((OpenApiParameter)param);
            }
        });
        int idx = 0;
        for (OpenApiParameter resolvedParam : resolvedParams) {
            int count;
            if (this.hasValue(resolvedParam) && this.hasValue(resolvedParam.getIn()) && this.hasValue(resolvedParam.getName()) && !this.equals(resolvedParam.getIn(), "body") && (count = this.getParamCount(resolvedParams, resolvedParam.getName(), resolvedParam.getIn())) > 1) {
                OpenApiParameter param2 = params.get(idx);
                this.report(param2, "in", this.map("paramIn", resolvedParam.getIn(), "paramName", resolvedParam.getName()));
            }
            ++idx;
        }
    }

    @Override
    public void visitPathItem(OpenApiPathItem node) {
        this.ensureUnique((OpenApiParametersParent)((Object)node));
    }

    @Override
    public void visitOperation(Operation node) {
        OpenApiOperation op = (OpenApiOperation)node;
        this.ensureUnique((OpenApiParametersParent)((Object)op));
    }
}

