/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.AbstractSchemaInhCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import java.util.List;

public class AddChildSchemaCommand
extends AbstractSchemaInhCommand {
    public NodePath _schemaPath;
    public String _newChildSchemaType;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _newChildSchemaObj;
    public boolean _nullChildList;
    public int _childIndex;

    AddChildSchemaCommand() {
    }

    AddChildSchemaCommand(OasSchema schema, OasSchema childSchema, String childType) {
        this._schemaPath = Library.createNodePath(schema);
        this._newChildSchemaObj = Library.writeNode(childSchema);
        this._newChildSchemaType = childType;
    }

    @Override
    public void execute(Document document) {
        Oas30Schema schema30;
        LoggerCompat.info("[AddChildSchemaCommand] Executing.", new Object[0]);
        this._nullChildList = false;
        this._childIndex = -1;
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        List<OasSchema> schemas = null;
        OasSchema newSchema = null;
        if (NodeCompat.equals("allOf", this._newChildSchemaType)) {
            schemas = schema.allOf;
            newSchema = schema.createAllOfSchema();
            Library.readNode(this._newChildSchemaObj, newSchema);
            schema.addAllOfSchema(newSchema);
            this._childIndex = schema.allOf.size() - 1;
        }
        if (NodeCompat.equals("anyOf", this._newChildSchemaType)) {
            schema30 = (Oas30Schema)schema;
            schemas = schema30.anyOf;
            newSchema = ((Oas30Schema)schema).createAnyOfSchema();
            Library.readNode(this._newChildSchemaObj, newSchema);
            ((Oas30Schema)schema).addAnyOfSchema((Oas30Schema.Oas30AnyOfSchema)newSchema);
            this._childIndex = ((Oas30Schema)schema).anyOf.size() - 1;
        }
        if (NodeCompat.equals("oneOf", this._newChildSchemaType)) {
            schema30 = (Oas30Schema)schema;
            schemas = schema30.oneOf;
            newSchema = ((Oas30Schema)schema).createOneOfSchema();
            Library.readNode(this._newChildSchemaObj, newSchema);
            ((Oas30Schema)schema).addOneOfSchema((Oas30Schema.Oas30OneOfSchema)newSchema);
            this._childIndex = ((Oas30Schema)schema).oneOf.size() - 1;
        }
        if (schemas == null) {
            this._nullChildList = true;
        }
    }

    @Override
    public void undo(Document document) {
        Oas30Schema schema30;
        LoggerCompat.info("[AddChildSchemaCommand] Reverting.", new Object[0]);
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema) || this._childIndex == -1) {
            return;
        }
        if (NodeCompat.equals("allOf", this._newChildSchemaType)) {
            if (this._nullChildList) {
                schema.allOf = null;
            } else {
                schema.allOf.remove(this._childIndex);
            }
        }
        if (NodeCompat.equals("anyOf", this._newChildSchemaType)) {
            schema30 = (Oas30Schema)schema;
            if (this._nullChildList) {
                schema30.anyOf = null;
            } else {
                schema30.anyOf.remove(this._childIndex);
            }
        }
        if (NodeCompat.equals("oneOf", this._newChildSchemaType)) {
            schema30 = (Oas30Schema)schema;
            if (this._nullChildList) {
                schema30.oneOf = null;
            } else {
                schema30.oneOf.remove(this._childIndex);
            }
        }
    }
}

