/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.io;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.ValidationProblem;
import io.apicurio.datamodels.core.models.common.Contact;
import io.apicurio.datamodels.core.models.common.ExternalDocumentation;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.core.models.common.License;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.models.common.Tag;
import io.apicurio.datamodels.core.visitors.IVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataModelWriter
implements IVisitor {
    private Object _result;
    private Map<Integer, Object> _modelIdToJS;

    public DataModelWriter() {
        this.reset();
    }

    private void reset() {
        this._modelIdToJS = new HashMap<Integer, Object>();
    }

    public Object getResult() {
        return JsonCompat.removeNullProperties(this._result);
    }

    protected void updateIndex(Node node, Object json) {
        this._modelIdToJS.put(node.modelId(), json);
        if (this._result == null) {
            this._result = json;
        }
    }

    protected void writeExtraProperties(Object json, Node node) {
        node.getExtraPropertyNames().forEach(pname -> {
            Object value = node.getExtraProperty((String)pname);
            JsonCompat.setProperty(json, pname, value);
        });
    }

    protected Object lookup(int modelId, Object jsonDefault) {
        Objects.requireNonNull(jsonDefault);
        Object rval = this._modelIdToJS.get(modelId);
        if (rval == null) {
            rval = jsonDefault;
        }
        return rval;
    }

    protected Object lookupParentJson(Node node) {
        return this.lookup(node.parent().modelId(), JsonCompat.objectNode());
    }

    protected Object lookupParentJson(Node node, Object jsonDefault) {
        return this.lookup(node.parent().modelId(), jsonDefault);
    }

    @Override
    public void visitDocument(Document node) {
        ObjectNode root = JsonCompat.objectNode();
        this.writeDocument(node, root);
        this.updateIndex(node, root);
    }

    protected void writeDocument(Document node, Object json) {
    }

    @Override
    public void visitExtension(Extension node) {
        Object parent = this.lookupParentJson(node);
        JsonCompat.setProperty(parent, node.name, node.value);
    }

    @Override
    public void visitInfo(Info node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "title", node.title);
        JsonCompat.setPropertyString(json, "version", node.version);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyString(json, "termsOfService", node.termsOfService);
        JsonCompat.setPropertyNull(json, "contact");
        JsonCompat.setPropertyNull(json, "license");
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "info", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitContact(Contact node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "name", node.name);
        JsonCompat.setPropertyString(json, "url", node.url);
        JsonCompat.setPropertyString(json, "email", node.email);
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "contact", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitLicense(License node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "name", node.name);
        JsonCompat.setPropertyString(json, "url", node.url);
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "license", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitTag(Tag node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "name", node.name);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyNull(json, "externalDocs");
        this.writeExtraProperties(json, node);
        JsonCompat.appendToArrayProperty(parent, "tags", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        node.getSecurityRequirementNames().forEach(name -> {
            List<String> scopes = node.getScopes((String)name);
            JsonCompat.setPropertyStringArray(json, name, scopes);
        });
        JsonCompat.appendToArrayProperty(parent, "security", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitExternalDocumentation(ExternalDocumentation node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyString(json, "url", node.url);
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, "externalDocs", json);
        this.updateIndex(node, json);
    }

    @Override
    public void visitOperation(Operation node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeOperation(json, node);
        this.writeExtraProperties(json, node);
        JsonCompat.setProperty(parent, node.getType(), json);
        this.updateIndex(node, json);
    }

    protected void writeOperation(Object json, Operation node) {
        JsonCompat.setPropertyString(json, "operationId", node.operationId);
        JsonCompat.setPropertyString(json, "summary", node.summary);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyNull(json, "externalDocs");
    }

    @Override
    public void visitParameter(Parameter node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeParameter(json, node);
        this.writeExtraProperties(json, node);
        JsonCompat.appendToArrayProperty(parent, "parameters", json);
        this.updateIndex(node, json);
    }

    protected void writeParameter(Object json, Parameter node) {
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
        JsonCompat.setPropertyString(json, "name", node.name);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyNull(json, "schema");
    }

    @Override
    public void visitSchema(Schema node) {
        this.doVisitSchema(node, "schema", false);
    }

    protected void doVisitSchema(Schema node, String parentPropertyName, boolean isCollection) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeSchema(json, node);
        this.writeExtraProperties(json, node);
        if (isCollection) {
            JsonCompat.appendToArrayProperty(parent, parentPropertyName, json);
        } else {
            JsonCompat.setProperty(parent, parentPropertyName, json);
        }
        this.updateIndex(node, json);
    }

    protected void writeSchema(Object json, Schema node) {
        JsonCompat.setPropertyString(json, "$ref", node.$ref);
    }

    @Override
    public void visitValidationProblem(ValidationProblem problem) {
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        Object parent = this.lookupParentJson(node);
        ObjectNode json = JsonCompat.objectNode();
        this.writeSecurityScheme(json, node);
        this.writeExtraProperties(json, node);
        this.addSecuritySchemeToParent(parent, json, node);
        this.updateIndex(node, json);
    }

    protected void writeSecurityScheme(Object json, SecurityScheme node) {
        JsonCompat.setPropertyString(json, "type", node.type);
        JsonCompat.setPropertyString(json, "description", node.description);
        JsonCompat.setPropertyString(json, "name", node.name);
        JsonCompat.setPropertyString(json, "in", node.in);
    }

    protected void addSecuritySchemeToParent(Object parent, Object json, SecurityScheme node) {
        JsonCompat.setProperty(parent, node.getSchemeName(), json);
    }

    @Override
    public void visitSchemaDefinition(IDefinition node) {
        Schema schema = (Schema)((Object)node);
        Object parent = this.lookupParentJson(schema);
        ObjectNode json = JsonCompat.objectNode();
        this.writeSchema(json, schema);
        this.writeExtraProperties(json, schema);
        this.addSchemaDefinitionToParent(parent, json, node);
        this.updateIndex(schema, json);
    }

    protected void addSchemaDefinitionToParent(Object parent, Object json, IDefinition node) {
        JsonCompat.setProperty(parent, node.getName(), json);
    }

    @Override
    public void visitParameterDefinition(IDefinition node) {
        Parameter pdef = (Parameter)((Object)node);
        Object parent = this.lookupParentJson(pdef);
        ObjectNode json = JsonCompat.objectNode();
        this.writeParameter(json, pdef);
        this.writeExtraProperties(json, pdef);
        this.addParameterDefinitionToParent(parent, json, node);
        this.updateIndex(pdef, json);
    }

    protected void addParameterDefinitionToParent(Object parent, Object json, IDefinition node) {
        JsonCompat.setProperty(parent, node.getName(), json);
    }
}

